/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Utils;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class MultibranchPipelineRunContainer
extends BlueRunContainer {
    private static final int MAX_MBP_RUNS_ROWS = Integer.getInteger("MAX_MBP_RUNS_ROWS", 250);
    private final MultiBranchPipelineImpl blueMbPipeline;
    private final Link self;

    public MultibranchPipelineRunContainer(MultiBranchPipelineImpl pipeline) {
        this.blueMbPipeline = pipeline;
        this.self = pipeline.getLink().rel("runs");
    }

    public Link getLink() {
        return this.self;
    }

    public BlueRun get(String name) {
        return null;
    }

    public Iterator<BlueRun> iterator() {
        throw new ServiceException.NotImplementedException("Not implemented");
    }

    public Iterator<BlueRun> iterator(int start, int limit) {
        List<Object> branches;
        ArrayList<BlueRun> c = new ArrayList<BlueRun>();
        StaplerRequest req = Stapler.getCurrentRequest();
        String branchFilter = null;
        if (req != null) {
            branchFilter = req.getParameter("branch");
        }
        if (!StringUtils.isEmpty(branchFilter)) {
            BluePipeline pipeline = (BluePipeline)this.blueMbPipeline.getBranches().get(branchFilter);
            branches = pipeline != null ? Collections.singletonList(pipeline) : Collections.emptyList();
        } else {
            branches = Lists.newArrayList((Iterable)this.blueMbPipeline.getBranches().list());
            MultibranchPipelineRunContainer.sortBranchesByLatestRun(branches);
        }
        for (BluePipeline b : branches) {
            BlueRunContainer blueRunContainer = b.getRuns();
            if (blueRunContainer == null) continue;
            Iterator it = blueRunContainer.iterator(0, MAX_MBP_RUNS_ROWS);
            int count = 0;
            Utils.skip((Iterator)it, (int)start);
            while (it.hasNext() && count++ < limit) {
                c.add((BlueRun)it.next());
            }
        }
        Collections.sort(c, PipelineRunImpl.LATEST_RUN_START_TIME_COMPARATOR);
        return Iterators.limit(c.iterator(), (int)limit);
    }

    static void sortBranchesByLatestRun(List<BluePipeline> branches) {
        Collections.sort(branches, (o1, o2) -> PipelineRunImpl.LATEST_RUN_START_TIME_COMPARATOR.compare(o1.getLatestRun(), o2.getLatestRun()));
    }

    private boolean retry(boolean[] retries) {
        for (boolean r : retries) {
            if (!r) continue;
            return true;
        }
        return false;
    }

    private int computeLimit(boolean[] retries, int limit) {
        int count = 0;
        for (boolean r : retries) {
            if (!r) continue;
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return limit / count > 0 ? limit / count : 1;
    }

    private int collectRuns(List<BluePipeline> branches, List<BlueRun> runs, boolean[] retries, int remainingCount, int[] startIndexes, int[] limits) {
        int count = 0;
        for (int i = 0; i < branches.size(); ++i) {
            BlueRunContainer blueRunContainer;
            BluePipeline b = branches.get(i);
            if (!retries[i] || (blueRunContainer = b.getRuns()) == null) continue;
            Iterator it = blueRunContainer.iterator(startIndexes[i], limits[i]);
            int lcount = 0;
            while (it.hasNext() && count < remainingCount) {
                ++lcount;
                ++count;
                runs.add((BlueRun)it.next());
            }
            if (lcount < limits[i]) {
                retries[i] = false;
                continue;
            }
            startIndexes[i] = startIndexes[i] + lcount;
        }
        return count;
    }

    public BlueRun create(StaplerRequest request) {
        this.blueMbPipeline.mbp.checkPermission(Item.BUILD);
        Queue.Item queueItem = this.blueMbPipeline.mbp.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
        if (queueItem == null) {
            return null;
        }
        return new QueueItemImpl(this.blueMbPipeline.getOrganization(), queueItem, (BluePipeline)this.blueMbPipeline, 1).toRun();
    }
}

