/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.preload.BlueUrlTokenizer;
import io.jenkins.blueocean.preload.PipelineActivityStatePreloader;
import io.jenkins.blueocean.preload.RESTFetchPreloader;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Extension
public class BlueRunChangesetPreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(PipelineActivityStatePreloader.class.getName());

    @Override
    protected RESTFetchPreloader.FetchData getFetchData(@Nonnull BlueUrlTokenizer blueUrl) {
        if (!blueUrl.lastPartIs(BlueUrlTokenizer.UrlPart.PIPELINE_RUN_DETAIL_TAB, "changes")) {
            return null;
        }
        BluePipeline pipeline = this.getPipeline(blueUrl);
        if (pipeline == null) {
            return null;
        }
        BlueRunContainer activitiesContainer = pipeline.getRuns();
        if (activitiesContainer == null) {
            return null;
        }
        BlueRun run = (BlueRun)activitiesContainer.get(blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE_RUN_DETAIL_ID));
        Container containerChangeSets = run.getChangeSet();
        return this.getFetchData((Container<BlueChangeSetEntry>)containerChangeSets);
    }

    public RESTFetchPreloader.FetchData getFetchData(Container<BlueChangeSetEntry> containerChangeSets) {
        try {
            JSONArray changeSetEntries = new JSONArray();
            for (BlueChangeSetEntry changeSetEntry : containerChangeSets) {
                changeSetEntries.add((Object)JSONObject.fromObject((Object)Export.toJson((Object)changeSetEntry)));
            }
            return new RESTFetchPreloader.FetchData(containerChangeSets.getLink().getHref() + "?start=0&limit=101", changeSetEntries.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, String.format("Unable to preload changelog data '%s'. Failed to convert to Blue Ocean Resource.", containerChangeSets.getLink().getHref()));
            return null;
        }
    }

    private BluePipeline getPipeline(BlueUrlTokenizer blueUrl) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        String pipelineFullName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE);
        try {
            Item pipelineJob = jenkins.getItemByFullName(pipelineFullName);
            return (BluePipeline)BluePipelineFactory.resolve((Item)pipelineJob);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, String.format("Unable to find Job named '%s'.", pipelineFullName), e);
            return null;
        }
    }
}

