/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.google.common.base.Optional;
import hudson.Extension;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.Caches;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.ScmResourceImpl;
import io.jenkins.blueocean.rest.model.BlueIssue;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.Resource;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueBranch", "org.jenkinsci.plugins.workflow.job.WorkflowJob", "io.jenkins.blueocean.rest.model.PullRequest"})
public class BranchImpl
extends PipelineImpl {
    public static final String ISSUES = "issues";
    private final Link parent;
    protected final Job job;

    public BranchImpl(BlueOrganization org, Job job, Link parent) {
        super(org, job);
        this.job = job;
        this.parent = parent;
    }

    @Exported(name="issues", skipNull=true, inline=true)
    public Collection<BlueIssue> getIssues() {
        return BlueIssueFactory.resolve((Job)this.job);
    }

    @Exported(name="pullRequest", inline=true, skipNull=true)
    public PullRequest getPullRequest() {
        return PullRequest.get(this.job);
    }

    @Exported(name="branch", inline=true)
    public Branch getBranch() {
        ObjectMetadataAction om = (ObjectMetadataAction)this.job.getAction(ObjectMetadataAction.class);
        PrimaryInstanceMetadataAction pima = (PrimaryInstanceMetadataAction)this.job.getAction(PrimaryInstanceMetadataAction.class);
        String url = om != null && om.getObjectUrl() != null ? om.getObjectUrl() : null;
        return new Branch(url, pima != null);
    }

    public Link getLink() {
        return this.parent.rel(Util.rawEncode((String)this.getName()));
    }

    @Navigable
    public BluePipelineScm getScm() {
        if (this.job instanceof WorkflowJob && this.job.getParent() instanceof ComputedFolder) {
            return new ScmResourceImpl((Item)((ComputedFolder)this.job.getParent()), (BuildableItem)this.job, (Reachable)this);
        }
        return null;
    }

    @ExportedBean
    public static class PullRequest {
        public static final String PULL_REQUEST = "pullRequest";
        public static final String PULL_REQUEST_NUMBER = "id";
        public static final String PULL_REQUEST_AUTHOR = "author";
        public static final String PULL_REQUEST_TITLE = "title";
        public static final String PULL_REQUEST_URL = "url";
        private final String id;
        private final String url;
        private final String title;
        private final String author;

        public PullRequest(String id, String url, String title, String author) {
            this.id = id;
            this.url = url;
            this.title = title;
            this.author = author;
        }

        @Exported(name="id")
        public String getId() {
            return this.id;
        }

        @Exported(name="url")
        public String getUrl() {
            return this.url;
        }

        @Exported(name="title")
        public String getTitle() {
            return this.title;
        }

        @Exported(name="author")
        public String getAuthor() {
            return this.author;
        }

        public static PullRequest get(Job job) {
            try {
                return (PullRequest)((Optional)Caches.PULL_REQUEST_METADATA.get((Object)job.getFullName())).orNull();
            }
            catch (ExecutionException e) {
                throw new ServiceException.UnexpectedErrorException("loading pr metadata for '" + job.getFullName() + "'", (Throwable)e);
            }
        }
    }

    @ExportedBean
    public static class Branch {
        public static final String BRANCH = "branch";
        public static final String BRANCH_URL = "url";
        public static final String BRANCH_PRIMARY = "isPrimary";
        private final String url;
        private final boolean primary;

        public Branch(String url, boolean primary) {
            this.url = url;
            this.primary = primary;
        }

        @Exported(name="url")
        public String getUrl() {
            return this.url;
        }

        @Exported(name="isPrimary")
        public boolean isPrimary() {
            return this.primary;
        }

        public static Branch getBranch(Job job) {
            try {
                return (Branch)((Optional)Caches.BRANCH_METADATA.get((Object)job.getFullName())).orNull();
            }
            catch (ExecutionException e) {
                throw new ServiceException.UnexpectedErrorException("loading branch metadata for '" + job.getFullName() + "'", (Throwable)e);
            }
        }
    }

    @Extension(ordinal=4.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof WorkflowJob && item.getParent() instanceof MultiBranchProject) {
                return new BranchImpl(organization, (Job)item, parent.getLink());
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context == target.getParent()) {
                return this.getPipeline(context, parent, organization);
            }
            return null;
        }
    }
}

