/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import hudson.Extension;
import io.jenkins.blueocean.commons.PageStatePreloader;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.sf.json.util.JSONBuilder;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class OrganizationStatePreloader
extends PageStatePreloader {
    private static final Pattern pattern = Pattern.compile("/blue/organizations/([^/]*)/");

    @Nonnull
    public String getStatePropertyPath() {
        return "organization";
    }

    public String getStateJson() {
        Iterator iterator;
        String orgName = this.getOrganizationFromURL();
        BlueOrganization organization = null;
        OrganizationFactory orgFactory = OrganizationFactory.getInstance();
        if (orgName != null) {
            organization = orgFactory.get(orgName);
        }
        if (organization == null && (iterator = orgFactory.list().iterator()).hasNext()) {
            organization = (BlueOrganization)iterator.next();
        }
        if (organization != null) {
            String organizationGroup = "/";
            if (organization instanceof AbstractOrganization) {
                organizationGroup = "/" + ((AbstractOrganization)organization).getGroup().getFullName();
            }
            StringWriter writer = new StringWriter();
            new JSONBuilder((Writer)writer).object().key("name").value((Object)organization.getName()).key("displayName").value((Object)organization.getDisplayName()).key("organizationGroup").value((Object)organizationGroup).endObject();
            return writer.toString();
        }
        return "{}";
    }

    private String getOrganizationFromURL() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest == null) {
            return null;
        }
        String requestURI = currentRequest.getRequestURI();
        if (requestURI == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(requestURI);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

