/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;

class Caches {
    static final long PR_METADATA_CACHE_MAX_SIZE = Long.getLong("PR_METADATA_CACHE_MAX_SIZE", 10000L);
    static final long BRANCH_METADATA_CACHE_MAX_SIZE = Long.getLong("BRANCH_METADATA_CACHE_MAX_SIZE", 10000L);
    static final LoadingCache<String, Optional<BranchImpl.PullRequest>> PULL_REQUEST_METADATA = CacheBuilder.newBuilder().maximumSize(PR_METADATA_CACHE_MAX_SIZE).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new PullRequestCacheLoader(Jenkins.getInstance().getItemGroup()));
    static final LoadingCache<String, Optional<BranchImpl.Branch>> BRANCH_METADATA = CacheBuilder.newBuilder().maximumSize(BRANCH_METADATA_CACHE_MAX_SIZE).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new BranchCacheLoader(Jenkins.getInstance().getItemGroup()));

    private Caches() {
    }

    static class PullRequestCacheLoader
    extends CacheLoader<String, Optional<BranchImpl.PullRequest>> {
        private Jenkins jenkins;

        PullRequestCacheLoader(Jenkins jenkins) {
            this.jenkins = jenkins;
        }

        public Optional<BranchImpl.PullRequest> load(String key) throws Exception {
            Job job = (Job)this.jenkins.getItemByFullName(key, Job.class);
            if (job == null) {
                return Optional.absent();
            }
            SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
            if (head instanceof ChangeRequestSCMHead) {
                ChangeRequestSCMHead cr = (ChangeRequestSCMHead)head;
                ObjectMetadataAction om = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
                ContributorMetadataAction cm = (ContributorMetadataAction)job.getAction(ContributorMetadataAction.class);
                return Optional.of((Object)new BranchImpl.PullRequest(cr.getId(), om != null ? om.getObjectUrl() : null, om != null ? om.getObjectDisplayName() : null, cm != null ? cm.getContributor() : null));
            }
            return Optional.absent();
        }
    }

    static class BranchCacheLoader
    extends CacheLoader<String, Optional<BranchImpl.Branch>> {
        private Jenkins jenkins;

        BranchCacheLoader(Jenkins jenkins) {
            this.jenkins = jenkins;
        }

        public Optional<BranchImpl.Branch> load(String key) throws Exception {
            Job job = (Job)this.jenkins.getItemByFullName(key, Job.class);
            if (job == null) {
                return Optional.absent();
            }
            ObjectMetadataAction om = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
            PrimaryInstanceMetadataAction pima = (PrimaryInstanceMetadataAction)job.getAction(PrimaryInstanceMetadataAction.class);
            if (om == null && pima == null) {
                return Optional.absent();
            }
            String url = om != null && om.getObjectUrl() != null ? om.getObjectUrl() : null;
            return Optional.of((Object)new BranchImpl.Branch(url, pima != null));
        }
    }

    @Extension
    public static class ListenerImpl
    extends ItemListener {
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.invalidate((Object)oldFullName);
            BRANCH_METADATA.invalidate((Object)oldFullName);
            PULL_REQUEST_METADATA.refresh((Object)newFullName);
            BRANCH_METADATA.refresh((Object)newFullName);
        }

        public void onUpdated(Item item) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.refresh((Object)item.getFullName());
            BRANCH_METADATA.refresh((Object)item.getFullName());
        }

        public void onDeleted(Item item) {
            if (!(item instanceof Job)) {
                return;
            }
            PULL_REQUEST_METADATA.invalidate((Object)item.getFullName());
            BRANCH_METADATA.invalidate((Object)item.getFullName());
        }
    }
}

