/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.model.Item;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.Connector;

public abstract class ScmContentProviderParams {
    private final String apiUrl;
    private final String owner;
    private final String repo;
    private final StandardUsernamePasswordCredentials credentials;

    public ScmContentProviderParams(Item item) {
        StandardCredentials credentials;
        List sources;
        String apiUrl = null;
        String owner = null;
        String repo = null;
        String credentialId = null;
        if (item instanceof OrganizationFolder) {
            List navigators = ((OrganizationFolder)item).getSCMNavigators();
            if (!navigators.isEmpty()) {
                SCMNavigator navigator = (SCMNavigator)navigators.get(0);
                apiUrl = this.apiUrl(navigator);
                credentialId = this.credentialId(navigator);
                owner = this.owner(navigator);
            }
        } else if (item instanceof MultiBranchProject && !(sources = ((MultiBranchProject)item).getSCMSources()).isEmpty()) {
            SCMSource source = (SCMSource)sources.get(0);
            apiUrl = this.apiUrl(source);
            credentialId = this.credentialId(source);
            owner = this.owner(source);
            repo = this.repo(source);
        }
        this.apiUrl = apiUrl;
        StandardUsernamePasswordCredentials cred = null;
        if (credentialId != null && (credentials = Connector.lookupScanCredentials((Item)item, (String)this.apiUrl, credentialId)) instanceof StandardUsernamePasswordCredentials) {
            cred = (StandardUsernamePasswordCredentials)credentials;
        }
        this.owner = owner;
        this.repo = repo;
        this.credentials = cred;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public StandardUsernamePasswordCredentials getCredentials() {
        return this.credentials;
    }

    @CheckForNull
    protected abstract String owner(@Nonnull SCMSource var1);

    @CheckForNull
    protected abstract String owner(@Nonnull SCMNavigator var1);

    @CheckForNull
    protected abstract String repo(@Nonnull SCMSource var1);

    @CheckForNull
    protected abstract String apiUrl(@Nonnull SCMSource var1);

    @CheckForNull
    protected abstract String apiUrl(@Nonnull SCMNavigator var1);

    @CheckForNull
    protected abstract String credentialId(@Nonnull SCMSource var1);

    @CheckForNull
    protected abstract String credentialId(@Nonnull SCMNavigator var1);
}

