/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.commons.BlueUrlTokenizer;
import io.jenkins.blueocean.commons.RESTFetchPreloader;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Extension
public class FavoritesStatePreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(FavoritesStatePreloader.class.getName());

    protected RESTFetchPreloader.FetchData getFetchData(@Nonnull BlueUrlTokenizer blueUrl) {
        UserImpl blueUser;
        BlueFavoriteContainer favoritesContainer;
        User jenkinsUser = User.current();
        if (jenkinsUser != null && (favoritesContainer = (blueUser = new UserImpl(jenkinsUser)).getFavorites()) != null) {
            JSONArray favorites = new JSONArray();
            for (Reachable favorite : favoritesContainer) {
                try {
                    favorites.add((Object)JSONObject.fromObject((Object)Export.toJson((Object)favorite)));
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, String.format("Unable to preload favorites for User '%s'. Serialization error.", jenkinsUser.getFullName()), e);
                    return null;
                }
            }
            return new RESTFetchPreloader.FetchData(favoritesContainer.getLink().getHref(), favorites.toString());
        }
        return null;
    }
}

