/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractBlueRunSummary;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueTrendContainerImpl;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Capability(value={"org.jenkinsci.plugins.workflow.job.WorkflowJob"})
public class PipelineImpl
extends AbstractPipelineImpl {
    private final Job job;

    protected PipelineImpl(BlueOrganization organization, Job job) {
        super(organization, job);
        this.job = job;
    }

    public BlueTrendContainer getTrends() {
        return new BlueTrendContainerImpl((BluePipeline)this);
    }

    public BlueRun getLatestRun() {
        Run run = this.job.getLastBuild();
        if (run instanceof WorkflowRun) {
            PipelineRunImpl blueRun = new PipelineRunImpl((WorkflowRun)run, (Reachable)this, this.organization);
            return new PipelineRunSummary((BlueRun)blueRun, run, (Reachable)this, this.organization);
        }
        return super.getLatestRun();
    }

    @Capability(value={"org.jenkinsci.plugins.workflow.job.WorkflowRun"})
    static class PipelineRunSummary
    extends AbstractBlueRunSummary {
        public PipelineRunSummary(BlueRun blueRun, Run run, Reachable parent, BlueOrganization organization) {
            super(blueRun, run, parent, organization);
        }

        public Container<BlueChangeSetEntry> getChangeSet() {
            return this.blueRun.getChangeSet();
        }
    }

    @Extension(ordinal=1.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg(item);
            if (org != null && item instanceof WorkflowJob) {
                return new PipelineImpl(org, (Job)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context == target && target instanceof WorkflowJob) {
                return this.getPipeline(target, parent, organization);
            }
            return null;
        }
    }
}

