/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Action;
import hudson.model.Result;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;

public class FlowNodeWrapper {
    private final FlowNode node;
    private final NodeRunStatus status;
    private final TimingInfo timingInfo;
    public final List<FlowNodeWrapper> edges = new ArrayList<FlowNodeWrapper>();
    public final NodeType type;
    private final String displayName;
    private final InputStep inputStep;
    private final WorkflowRun run;
    private String causeOfFailure;
    private List<FlowNodeWrapper> parents = new ArrayList<FlowNodeWrapper>();
    private ErrorAction blockErrorAction;
    private Collection<Action> pipelineActions;

    public FlowNodeWrapper(@Nonnull FlowNode node, @Nonnull NodeRunStatus status, @Nonnull TimingInfo timingInfo, @Nonnull WorkflowRun run) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = FlowNodeWrapper.getNodeType(node);
        this.displayName = PipelineNodeUtil.getDisplayName(node);
        this.inputStep = null;
        this.run = run;
    }

    public FlowNodeWrapper(@Nonnull FlowNode node, @Nonnull NodeRunStatus status, @Nonnull TimingInfo timingInfo, @Nullable InputStep inputStep, @Nonnull WorkflowRun run) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = FlowNodeWrapper.getNodeType(node);
        this.displayName = PipelineNodeUtil.getDisplayName(node);
        this.inputStep = inputStep;
        this.run = run;
    }

    public WorkflowRun getRun() {
        return this.run;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    private static NodeType getNodeType(FlowNode node) {
        if (PipelineNodeUtil.isStage(node)) {
            return NodeType.STAGE;
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return NodeType.PARALLEL;
        }
        if (node instanceof AtomNode) {
            return NodeType.STEP;
        }
        throw new IllegalArgumentException(String.format("Unknown FlowNode %s, type: %s", node.getId(), node.getClass()));
    }

    @Nonnull
    public NodeRunStatus getStatus() {
        if (this.hasBlockError()) {
            if (this.isBlockErrorInterruptedWithAbort()) {
                return new NodeRunStatus(BlueRun.BlueRunResult.ABORTED, BlueRun.BlueRunState.FINISHED);
            }
            return new NodeRunStatus(BlueRun.BlueRunResult.FAILURE, BlueRun.BlueRunState.FINISHED);
        }
        return this.status;
    }

    @Nonnull
    public TimingInfo getTiming() {
        return this.timingInfo;
    }

    @Nonnull
    public String getId() {
        return this.node.getId();
    }

    @Nonnull
    public FlowNode getNode() {
        return this.node;
    }

    public NodeType getType() {
        return this.type;
    }

    public void addEdge(FlowNodeWrapper edge) {
        this.edges.add(edge);
    }

    public void addEdges(List<FlowNodeWrapper> edges) {
        this.edges.addAll(edges);
    }

    public void addParent(FlowNodeWrapper parent) {
        this.parents.add(parent);
    }

    public void addParents(Collection<FlowNodeWrapper> parents) {
        this.parents.addAll(parents);
    }

    @CheckForNull
    public FlowNodeWrapper getFirstParent() {
        return this.parents.size() > 0 ? this.parents.get(0) : null;
    }

    @Nonnull
    public List<FlowNodeWrapper> getParents() {
        return this.parents;
    }

    public String getCauseOfFailure() {
        return this.causeOfFailure;
    }

    public void setCauseOfFailure(String causeOfFailure) {
        this.causeOfFailure = causeOfFailure;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowNodeWrapper)) {
            return false;
        }
        return this.node.equals((Object)((FlowNodeWrapper)obj).node);
    }

    @CheckForNull
    public InputStep getInputStep() {
        return this.inputStep;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.node.getId() + ",displayName=" + this.displayName + ",type=" + (Object)((Object)this.type) + "]";
    }

    boolean hasBlockError() {
        return this.blockErrorAction != null && this.blockErrorAction.getError() != null;
    }

    String blockError() {
        if (this.hasBlockError()) {
            return this.blockErrorAction.getError().getMessage();
        }
        return null;
    }

    @CheckForNull
    String nodeError() {
        ErrorAction errorAction = this.node.getError();
        if (errorAction != null) {
            return errorAction.getError().getMessage();
        }
        return null;
    }

    boolean isBlockErrorInterruptedWithAbort() {
        Throwable error;
        if (this.hasBlockError() && (error = this.blockErrorAction.getError()) instanceof FlowInterruptedException) {
            FlowInterruptedException interrupted = (FlowInterruptedException)error;
            return interrupted.getResult().equals(Result.ABORTED);
        }
        return false;
    }

    boolean isLoggable() {
        return PipelineNodeUtil.isLoggable.apply((Object)this.node);
    }

    public void setBlockErrorAction(ErrorAction blockErrorAction) {
        this.blockErrorAction = blockErrorAction;
    }

    public <T extends Action> Collection<T> getPipelineActions(Class<T> clazz) {
        if (this.pipelineActions == null) {
            return Collections.emptyList();
        }
        ArrayList<T> filtered = new ArrayList<T>();
        for (Action a : this.pipelineActions) {
            if (!clazz.isInstance(a)) continue;
            filtered.add(clazz.cast(a));
        }
        return filtered;
    }

    public void setPipelineActions(Collection<Action> pipelineActions) {
        this.pipelineActions = pipelineActions;
    }

    public static enum NodeType {
        STAGE,
        PARALLEL,
        STEP;

    }
}

