/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.HostnamePortSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.PathSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.User;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;

public class CredentialsUtils {
    public static void createCredentialsInUserStore(@Nonnull Credentials credential, @Nonnull User user, @Nonnull String domainName, @Nonnull List<DomainSpecification> domainSpecifications) throws IOException {
        CredentialsStore store = CredentialsUtils.findUserStoreFirstOrNull(user);
        if (store == null) {
            throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
        }
        Domain domain = CredentialsUtils.findOrCreateDomain(store, domainName, domainSpecifications);
        if (!store.addCredentials(domain, credential)) {
            throw new ServiceException.UnexpectedErrorException("Failed to add credential to domain");
        }
    }

    public static void updateCredentialsInUserStore(@Nonnull Credentials current, @Nonnull Credentials replacement, @Nonnull User user, @Nonnull String domainName, @Nonnull List<DomainSpecification> domainSpecifications) throws IOException {
        CredentialsStore store = CredentialsUtils.findUserStoreFirstOrNull(user);
        if (store == null) {
            throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
        }
        Domain domain = CredentialsUtils.findOrCreateDomain(store, domainName, domainSpecifications);
        if (!store.updateCredentials(domain, current, replacement)) {
            throw new ServiceException.UnexpectedErrorException("Failed to update credential to domain");
        }
    }

    @CheckForNull
    public static Domain findDomain(final @Nonnull String credentialId, @Nonnull User user) {
        for (final CredentialsStore store : CredentialsUtils.findUserStores(user)) {
            Optional d = Iterables.tryFind((Iterable)store.getDomains(), (Predicate)new Predicate<Domain>(){

                public boolean apply(@Nullable Domain input) {
                    return input != null && Iterables.tryFind((Iterable)store.getCredentials(input), (Predicate)new Predicate<Credentials>(){

                        public boolean apply(@Nullable Credentials input) {
                            return input != null && input instanceof IdCredentials && ((IdCredentials)input).getId().equals(credentialId);
                        }
                    }).isPresent();
                }
            });
            if (!d.isPresent()) continue;
            return (Domain)d.get();
        }
        return null;
    }

    @Nonnull
    public static Iterable<Domain> getUserDomains(@Nonnull User user) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (CredentialsStore store : CredentialsUtils.findUserStores(user)) {
            domains.addAll(store.getDomains());
        }
        for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
            domains.addAll(store.getDomains());
        }
        return domains;
    }

    @CheckForNull
    public static <C extends Credentials> C findCredential(@Nonnull String credentialId, @Nonnull Class<C> type, DomainRequirement ... domainRequirements) {
        return (C)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), (DomainRequirement[])domainRequirements), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId)}));
    }

    @CheckForNull
    private static CredentialsStore findUserStoreFirstOrNull(User user) {
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)user)) {
            if (!s.hasPermission(CredentialsProvider.CREATE) || !s.hasPermission(CredentialsProvider.UPDATE)) continue;
            return s;
        }
        return null;
    }

    @Nonnull
    private static Iterable<CredentialsStore> findUserStores(User user) {
        ArrayList<CredentialsStore> stores = new ArrayList<CredentialsStore>();
        for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)user)) {
            stores.add(store);
        }
        for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
            stores.add(store);
        }
        return stores;
    }

    public static List<DomainSpecification> generateDomainSpecifications(@Nullable String uriStr) {
        if (StringUtils.isBlank((CharSequence)uriStr)) {
            return Collections.emptyList();
        }
        ArrayList<DomainSpecification> domainSpecifications = new ArrayList<DomainSpecification>();
        try {
            URI uri = new URI(uriStr);
            String path = uri.getRawPath() == null ? null : (uri.getRawPath().trim().isEmpty() ? "/" : uri.getRawPath());
            domainSpecifications.add((DomainSpecification)new PathSpecification(path, "", false));
            if (uri.getPort() != -1) {
                domainSpecifications.add((DomainSpecification)new HostnamePortSpecification(uri.getHost() + ":" + uri.getPort(), null));
            } else {
                domainSpecifications.add((DomainSpecification)new HostnameSpecification(uri.getHost(), null));
            }
            domainSpecifications.add((DomainSpecification)new SchemeSpecification(uri.getScheme()));
        }
        catch (URISyntaxException e) {
            return domainSpecifications;
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static Domain findOrCreateDomain(@Nonnull CredentialsStore store, @Nonnull String domainName, @Nonnull List<DomainSpecification> domainSpecifications) throws IOException {
        Domain domain = store.getDomainByName(domainName);
        if (domain == null) {
            boolean result = store.addDomain(new Domain(domainName, domainName + " to store credentials by BlueOcean", domainSpecifications), new Credentials[0]);
            if (!result) {
                throw new ServiceException.BadRequestExpception("Failed to create credential domain: " + domainName);
            }
            domain = store.getDomainByName(domainName);
            if (domain == null) {
                throw new ServiceException.UnexpectedErrorException("Domain %s created but not found");
            }
        }
        return domain;
    }
}

