/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;

public class MultiBranchPipelineContainerImpl
extends BluePipelineContainer {
    private final OrganizationFolder folder;
    private final Link self;

    public MultiBranchPipelineContainerImpl(OrganizationFolder folder, Reachable parent) {
        this.folder = folder;
        this.self = parent.getLink();
    }

    public BlueMultiBranchPipeline get(String s) {
        MultiBranchProject mbp = this.folder.getItem(s);
        if (mbp == null) {
            throw new ServiceException.NotFoundException("Multibranch pipeline " + s + " not found.");
        }
        return new MultiBranchPipelineImpl(mbp);
    }

    public Link getLink() {
        return this.self;
    }

    public Iterator<BluePipeline> iterator() {
        ArrayList<MultiBranchPipelineImpl> pipelines = new ArrayList<MultiBranchPipelineImpl>();
        for (MultiBranchProject mbp : this.folder.getItems()) {
            pipelines.add(new MultiBranchPipelineImpl(mbp));
        }
        return pipelines.iterator();
    }
}

