/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.io.CountingOutputStream;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepImpl;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.kohsuke.stapler.AcceptHeader;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class NodeLogResource {
    private final Iterable<BluePipelineStep> steps;
    private final FlowNodeWrapper node;

    NodeLogResource(PipelineNodeImpl node) {
        this.node = node.getFlowNodeWrapper();
        this.steps = node.getSteps();
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp, @Header(value="Accept") AcceptHeader accept) {
        String download = req.getParameter("download");
        if ("true".equalsIgnoreCase(download)) {
            rsp.setHeader("Content-Disposition", "attachment; filename=log.txt");
        }
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.setStatus(200);
        long count = 0L;
        try (CharSpool spool = new CharSpool();){
            for (BluePipelineStep blueStep : this.steps) {
                String errorLog;
                if (!(blueStep instanceof PipelineStepImpl)) continue;
                PipelineStepImpl step = (PipelineStepImpl)blueStep;
                FlowNodeWrapper node = step.getFlowNodeWrapper();
                if (step.getFlowNodeWrapper().isLoggable()) {
                    count += ((LogAction)node.getNode().getAction(LogAction.class)).getLogText().writeLogTo(0L, (Writer)spool);
                    errorLog = node.blockError();
                    if (errorLog == null) continue;
                    count += this.appendError(errorLog, (OutputStream)new WriterOutputStream((Writer)spool));
                    continue;
                }
                errorLog = step.getFlowNodeWrapper().nodeError();
                if (errorLog == null) {
                    errorLog = step.getFlowNodeWrapper().blockError();
                }
                if (errorLog == null) continue;
                count += this.appendError(errorLog, (OutputStream)new WriterOutputStream((Writer)spool));
            }
            if (count > 0L) {
                Writer writer = count > 4096L ? rsp.getCompressedWriter((HttpServletRequest)req) : rsp.getWriter();
                spool.flush();
                spool.writeTo((Writer)new LineEndNormalizingWriter(writer));
                rsp.addHeader("X-Text-Size", String.valueOf(count));
                writer.close();
            }
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Error reading log");
        }
    }

    private long appendError(String msg, OutputStream w) throws IOException {
        try (CountingOutputStream os = new CountingOutputStream(w);){
            os.write(msg.getBytes("UTF-8"));
            os.flush();
            long l = os.getCount();
            return l;
        }
    }
}

