/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.google.common.base.Predicate;
import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.actions.ChangeRequestAction;

public class PipelineJobFilters {
    private static boolean isPullRequest(Item item) {
        SCMHead head = SCMHead.HeadByItem.findHead((Item)item);
        return head != null && head.getAction(ChangeRequestAction.class) != null;
    }

    @Extension
    public static class PullRequestFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = new Predicate<Item>(){

            public boolean apply(Item job) {
                return PipelineJobFilters.isPullRequest(job);
            }
        };

        public String getName() {
            return "pull-requests";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }

    @Extension
    public static class OriginFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = new Predicate<Item>(){

            public boolean apply(Item job) {
                return !PipelineJobFilters.isPullRequest(job);
            }
        };

        public String getName() {
            return "origin";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }

    @Extension
    public static class FolderJobFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = new Predicate<Item>(){

            public boolean apply(Item job) {
                return !Folder.class.equals(job.getClass()) && !(job instanceof OrganizationFolder);
            }
        };

        public String getName() {
            return "no-folders";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }
}

