/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.OrganizationFolderRunContainerImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.service.embedded.rest.PipelineFolderImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.Iterator;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;

public class OrganizationFolderPipelineImpl
extends PipelineFolderImpl {
    final OrganizationFolder folder;

    public OrganizationFolderPipelineImpl(OrganizationFolder folder, Link parent) {
        super((ItemGroup)folder, parent);
        this.folder = folder;
    }

    @Exported
    public String getIcon() {
        return this.folder.getIcon().getImageOf("32x32");
    }

    @Navigable
    public BluePipelineContainer getPipelines() {
        return new MultiBranchPipelineContainerImpl(this.folder, (Reachable)this);
    }

    @Navigable
    public BlueRunContainer getRuns() {
        return new OrganizationFolderRunContainerImpl(this, (Reachable)this);
    }

    @Exported(inline=true)
    public BlueRun getLatestRun() {
        return new OrganizationFolderRunContainerImpl(this, (Reachable)this).get("1");
    }

    public BlueQueueContainer getQueue() {
        return new BlueQueueContainer(){

            public BlueQueueItem get(String name) {
                for (Queue.Item item : Jenkins.getInstance().getQueue().getItems((Queue.Task)OrganizationFolderPipelineImpl.this.folder)) {
                    if (item.getId() != Long.parseLong(name)) continue;
                    return new QueueItemImpl(item, (BluePipeline)OrganizationFolderPipelineImpl.this, 1);
                }
                return null;
            }

            public Link getLink() {
                return OrganizationFolderPipelineImpl.this.getLink().rel("queue");
            }

            public Iterator<BlueQueueItem> iterator() {
                return new Iterator<BlueQueueItem>(){
                    Iterator<Queue.Item> it;
                    {
                        this.it = Jenkins.getInstance().getQueue().getItems((Queue.Task)OrganizationFolderPipelineImpl.this.folder).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public BlueQueueItem next() {
                        return new QueueItemImpl(this.it.next(), (BluePipeline)OrganizationFolderPipelineImpl.this, 1);
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static abstract class OrganizationFolderFactory
    extends PipelineFolderImpl.PipelineFactoryImpl {
        protected abstract OrganizationFolderPipelineImpl getFolder(OrganizationFolder var1, Reachable var2);

        public OrganizationFolderPipelineImpl getPipeline(Item item, Reachable parent) {
            if (item instanceof OrganizationFolder) {
                return this.getFolder((OrganizationFolder)item, parent);
            }
            return null;
        }
    }
}

