/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.impl.pipeline.BranchContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineQueueContainer;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueFavoriteResolver;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import io.jenkins.blueocean.service.embedded.rest.FavoriteImpl;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.actions.ChangeRequestAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.json.JsonBody;

@Capability(value={"jenkins.branch.MultiBranchProject"})
public class MultiBranchPipelineImpl
extends BlueMultiBranchPipeline {
    final MultiBranchProject mbp;
    private static final int MAX_MBP_RUNS_ROWS = Integer.getInteger("MAX_MBP_RUNS_ROWS", 250);
    private final Link self;

    public MultiBranchPipelineImpl(MultiBranchProject mbp) {
        this.mbp = mbp;
        this.self = OrganizationImpl.INSTANCE.getLink().rel("pipelines").rel(PipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    public String getOrganization() {
        return OrganizationImpl.INSTANCE.getName();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestExpception("Must provide pipeline name");
        }
        Job job = FavoriteUtil.resolveDefaultBranch((AbstractFolder)this.mbp);
        FavoriteUtil.toggle((BlueFavoriteAction)favoriteAction, (Item)job);
        return new FavoriteImpl((Object)new BranchImpl(job, this.getLink().rel("branches")), this.getLink().rel("favorite"));
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.mbp);
    }

    public String getName() {
        return this.mbp.getName();
    }

    public String getDisplayName() {
        return this.mbp.getDisplayName();
    }

    public String getFullName() {
        return this.mbp.getFullName();
    }

    public String getFullDisplayName() {
        return AbstractPipelineImpl.getFullDisplayName((ItemGroup)this.mbp, null);
    }

    public int getTotalNumberOfBranches() {
        return this.countJobs(false);
    }

    public int getNumberOfFailingBranches() {
        return this.countRunStatus(Result.FAILURE, false);
    }

    public int getNumberOfSuccessfulBranches() {
        return this.countRunStatus(Result.SUCCESS, false);
    }

    public int getTotalNumberOfPullRequests() {
        return this.countJobs(true);
    }

    public int getNumberOfFailingPullRequests() {
        return this.countRunStatus(Result.FAILURE, true);
    }

    public int getNumberOfSuccessfulPullRequests() {
        return this.countRunStatus(Result.SUCCESS, true);
    }

    public BluePipelineContainer getPipelines() {
        return new BranchContainerImpl(this, this.getLink().rel("pipelines"));
    }

    public Integer getNumberOfFolders() {
        return 0;
    }

    public Integer getNumberOfPipelines() {
        return this.getTotalNumberOfBranches();
    }

    public Integer getWeatherScore() {
        Collection jbs;
        Job j = this.mbp.getItem("master");
        if (j == null && (j = this.mbp.getItem("production")) == null && (jbs = this.mbp.getAllJobs()).size() > 0) {
            Job[] jobs = jbs.toArray(new Job[jbs.size()]);
            Arrays.sort(jobs, new Comparator<Job>(){

                @Override
                public int compare(Job o1, Job o2) {
                    long t1 = 0L;
                    if (o1.getLastBuild() != null) {
                        t1 = o1.getLastBuild().getTimeInMillis() + o1.getLastBuild().getDuration();
                    }
                    long t2 = 0L;
                    if (o2.getLastBuild() != null) {
                        t2 = o2.getLastBuild().getTimeInMillis() + o2.getLastBuild().getDuration();
                    }
                    if (t1 < 2L) {
                        return -1;
                    }
                    if (t1 > t2) {
                        return 1;
                    }
                    return 0;
                }
            });
            return jobs[jobs.length - 1].getBuildHealth().getScore();
        }
        return j == null ? 0 : j.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        return null;
    }

    public Long getEstimatedDurationInMillis() {
        return this.mbp.getEstimatedDuration();
    }

    public String getLastSuccessfulRun() {
        return null;
    }

    @Navigable
    public BluePipelineContainer getBranches() {
        return new BranchContainerImpl(this, this.getLink().rel("branches"));
    }

    public Collection<String> getBranchNames() {
        Collection jobs = this.mbp.getAllJobs();
        ArrayList<String> branches = new ArrayList<String>();
        for (Job j : jobs) {
            branches.add(j.getName());
        }
        return branches;
    }

    private int countRunStatus(Result result, boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int count = 0;
        for (Job j : jobs) {
            if ((!pullRequests || !this.isPullRequest(j)) && (pullRequests || this.isPullRequest(j))) continue;
            j.getBuildStatusUrl();
            Run run = j.getLastBuild();
            if (run == null || run.getResult() != result) continue;
            ++count;
        }
        return count;
    }

    private int countJobs(boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int counter = 0;
        for (Job job : jobs) {
            if ((!pullRequests || !this.isPullRequest(job)) && (pullRequests || this.isPullRequest(job))) continue;
            ++counter;
        }
        return counter;
    }

    private boolean isPullRequest(Job job) {
        SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
        return head != null && head.getAction(ChangeRequestAction.class) != null;
    }

    public BlueRunContainer getRuns() {
        return new BlueRunContainer(){

            public Link getLink() {
                return MultiBranchPipelineImpl.this.getLink().rel("runs");
            }

            public BlueRun get(String name) {
                return null;
            }

            public Iterator<BlueRun> iterator() {
                throw new ServiceException.NotImplementedException("Not implemented");
            }

            public Iterator<BlueRun> iterator(int start, int limit) {
                ArrayList c = new ArrayList();
                ArrayList branches = Lists.newArrayList((Iterable)MultiBranchPipelineImpl.this.getBranches().list());
                MultiBranchPipelineImpl.sortBranchesByLatestRun(branches);
                for (BluePipeline b : MultiBranchPipelineImpl.this.getBranches()) {
                    Iterator it = b.getRuns().iterator(0, MAX_MBP_RUNS_ROWS);
                    int count = 0;
                    Iterators.skip((Iterator)it, (int)start);
                    while (it.hasNext() && count++ < limit) {
                        c.add(it.next());
                    }
                }
                Collections.sort(c, new Comparator<BlueRun>(){

                    @Override
                    public int compare(BlueRun o1, BlueRun o2) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                });
                return c.iterator();
            }

            private boolean retry(boolean[] retries) {
                for (boolean r : retries) {
                    if (!r) continue;
                    return true;
                }
                return false;
            }

            private int computeLimit(boolean[] retries, int limit) {
                int count = 0;
                for (boolean r : retries) {
                    if (!r) continue;
                    ++count;
                }
                if (count == 0) {
                    return 0;
                }
                return limit / count > 0 ? limit / count : 1;
            }

            private int collectRuns(List<BluePipeline> branches, List<BlueRun> runs, boolean[] retries, int remainingCount, int[] startIndexes, int[] limits) {
                int count = 0;
                for (int i = 0; i < branches.size(); ++i) {
                    BluePipeline b = branches.get(i);
                    if (!retries[i]) continue;
                    Iterator it = b.getRuns().iterator(startIndexes[i], limits[i]);
                    int lcount = 0;
                    while (it.hasNext() && count < remainingCount) {
                        ++lcount;
                        ++count;
                        runs.add((BlueRun)it.next());
                    }
                    if (lcount < limits[i]) {
                        retries[i] = false;
                        continue;
                    }
                    startIndexes[i] = startIndexes[i] + lcount;
                }
                return count;
            }

            public BlueQueueItem create(StaplerRequest request) {
                throw new ServiceException.NotImplementedException("This action is not supported");
            }
        };
    }

    static void sortBranchesByLatestRun(List<BluePipeline> branches) {
        Collections.sort(branches, new Comparator<BluePipeline>(){

            @Override
            public int compare(BluePipeline o1, BluePipeline o2) {
                Long t1 = o1.getLatestRun() != null ? o1.getLatestRun().getStartTime().getTime() : 0L;
                Long t2 = o2.getLatestRun() != null ? o2.getLatestRun().getStartTime().getTime() : 0L;
                return t2.compareTo(t1);
            }
        });
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies((List)this.mbp.getAllActions(), (Reachable)this);
    }

    public BlueQueueContainer getQueue() {
        return new MultiBranchPipelineQueueContainer(this);
    }

    public Link getLink() {
        return this.self;
    }

    @Navigable
    public Container<Resource> getActivities() {
        return new Container<Resource>(){

            public Resource get(String name) {
                return null;
            }

            public Link getLink() {
                return MultiBranchPipelineImpl.this.getLink().rel("activities");
            }

            public Iterator<Resource> iterator() {
                throw new ServiceException.NotImplementedException("Not implemented");
            }

            public Iterator<Resource> iterator(int start, int limit) {
                return AbstractPipelineImpl.activityIterator((BlueQueueContainer)MultiBranchPipelineImpl.this.getQueue(), (BlueRunContainer)MultiBranchPipelineImpl.this.getRuns(), (int)start, (int)limit);
            }
        };
    }

    public List<Object> getParameters() {
        return null;
    }

    @Extension(ordinal=1.0)
    public static class FavoriteResolverImpl
    extends BlueFavoriteResolver {
        public BlueFavorite resolve(Item item, Reachable parent) {
            MultiBranchProject project;
            Job job;
            if (item instanceof MultiBranchProject && (job = FavoriteUtil.resolveDefaultBranch((AbstractFolder)(project = (MultiBranchProject)item))) != null) {
                Resource resource = BluePipelineFactory.resolve((Item)job);
                Link l = LinkResolver.resolveLink((Object)project);
                if (l != null) {
                    return new FavoriteImpl((Object)resource, l.rel("favorite"));
                }
            }
            return null;
        }
    }

    @Extension(ordinal=2.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public MultiBranchPipelineImpl getPipeline(Item item, Reachable parent) {
            if (item instanceof MultiBranchProject) {
                return new MultiBranchPipelineImpl((MultiBranchProject)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target) {
            if (context instanceof MultiBranchProject) {
                if (context == target) {
                    return this.getPipeline(context, parent);
                }
                if (context == target.getParent()) {
                    return (Resource)this.getPipeline(context, parent).getBranches().get(target.getName());
                }
            }
            return null;
        }
    }
}

