/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.blueocean_github_pipeline.GitHubFactory;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubCredentialUtils;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubOrganization;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubRepository;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubUserOrganization;
import io.jenkins.blueocean.blueocean_github_pipeline.HttpRequest;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainSpecification;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.GET;

public class GithubScm
extends AbstractScm {
    public static final String ID = "github";
    private static final String USER_EMAIL_SCOPE = "user:email";
    private static final String USER_SCOPE = "user";
    private static final String REPO_SCOPE = "repo";
    static final String DOMAIN_NAME = "blueocean-github-domain";
    static final String CREDENTIAL_DESCRIPTION = "GitHub Access Token";
    protected final Reachable parent;

    @NonNull
    static ObjectWriter getMappingObjectWriter() {
        return GitHub.getMappingObjectWriter();
    }

    @NonNull
    static ObjectReader getMappingObjectReader() {
        return GitHub.getMappingObjectReader();
    }

    public GithubScm(Reachable parent) {
        this.parent = parent;
    }

    public Link getLink() {
        return this.parent.getLink().rel(ID);
    }

    @NonNull
    public String getId() {
        return ID;
    }

    @NonNull
    public String getUri() {
        String apiUri = this.getCustomApiUri();
        if (!StringUtils.isEmpty((CharSequence)apiUri)) {
            return apiUri;
        }
        return "https://api.github.com";
    }

    public String getCredentialDomainName() {
        return DOMAIN_NAME;
    }

    public String getCredentialId() {
        StandardUsernamePasswordCredentials githubCredential = this.getCredential(this.getUri());
        if (githubCredential != null) {
            return githubCredential.getId();
        }
        return null;
    }

    StandardUsernamePasswordCredentials getCredential(String apiUrl) {
        String credentialId = this.createCredentialId(apiUrl);
        return (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
    }

    public Object getState() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Objects.requireNonNull(request, "Must be called in HTTP request context");
        String method = request.getMethod();
        if (!"POST".equalsIgnoreCase(method)) {
            throw new ServiceException.MethodNotAllowedException(String.format("Request method %s is not allowed", method));
        }
        this.checkPermission();
        this.validateExistingAccessToken();
        return super.getState();
    }

    private StandardUsernamePasswordCredentials getCredential() {
        StaplerRequest request = Stapler.getCurrentRequest();
        String credentialId = GithubCredentialUtils.computeCredentialId(GithubScm.getCredentialIdFromRequest((StaplerRequest)request), this.getId(), this.getUri());
        User authenticatedUser = this.getAuthenticatedUser();
        StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (credential == null) {
            throw new ServiceException.BadRequestException(String.format("Credential id: %s not found for user %s", credentialId, authenticatedUser.getId()));
        }
        return credential;
    }

    @GET
    @WebMethod(name={"repository"})
    @TreeResponse
    public GithubRepository getRepository(@QueryParameter String jobName, @QueryParameter String apiUrl) {
        TopLevelItem item = Jenkins.get().getItem(jobName);
        if (item == null) {
            throw new ServiceException.NotFoundException(String.format("Job %s not found", jobName));
        }
        GitHubSCMSource gitHubSCMSource = (GitHubSCMSource)((WorkflowMultiBranchProject)item).getSCMSource("blueocean");
        if (gitHubSCMSource == null) {
            throw new ServiceException.NotFoundException(String.format("GitHubSCMSource for Job %s not found", jobName));
        }
        String repoOwner = gitHubSCMSource.getRepoOwner();
        String repoName = gitHubSCMSource.getRepository();
        StandardUsernamePasswordCredentials credential = this.getCredential();
        String accessToken = credential.getPassword().getPlainText();
        try {
            String url = String.format("%s/repos/%s/%s", apiUrl, repoOwner, repoName);
            GHRepository ghRepository = HttpRequest.get(url).withAuthorizationToken(accessToken).to(GHRepository.class);
            return new GithubRepository(ghRepository, credential, (Reachable)this);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Container<ScmOrganization> getOrganizations() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Objects.requireNonNull(request, "This request must be made in HTTP context");
        String method = request.getMethod();
        if (!"POST".equalsIgnoreCase(method)) {
            throw new ServiceException.MethodNotAllowedException(String.format("Request method %s is not allowed", method));
        }
        StandardUsernamePasswordCredentials credential = this.getCredential();
        String accessToken = credential.getPassword().getPlainText();
        this.checkPermission();
        try {
            GitHub github = GitHubFactory.connect(accessToken, this.getUri());
            final Link link = this.getLink().rel("organizations");
            HashMap orgMap = new LinkedHashMap<String, GithubOrganization>();
            for (Map.Entry entry : github.getMyOrganizations().entrySet()) {
                orgMap.put((String)entry.getKey(), new GithubOrganization(this, (GHOrganization)entry.getValue(), credential, link));
            }
            GHMyself user = github.getMyself();
            if (orgMap.get(user.getLogin()) == null) {
                orgMap = new HashMap(orgMap);
                orgMap.put(user.getLogin(), new GithubUserOrganization(user, credential, this));
            }
            final LinkedHashMap<String, GithubOrganization> orgs = orgMap;
            return new Container<ScmOrganization>(){

                public ScmOrganization get(String name) {
                    ScmOrganization org = (ScmOrganization)orgs.get(name);
                    if (org == null) {
                        throw new ServiceException.NotFoundException(String.format("GitHub organization %s not found", name));
                    }
                    return org;
                }

                public Link getLink() {
                    return link;
                }

                public Iterator<ScmOrganization> iterator() {
                    return orgs.values().iterator();
                }
            };
        }
        catch (IOException e) {
            if (e instanceof HttpException) {
                HttpException ex = (HttpException)e;
                if (ex.getResponseCode() == 401) {
                    throw new ServiceException.PreconditionRequired("Invalid GitHub accessToken", (Throwable)ex);
                }
                if (ex.getResponseCode() == 403) {
                    throw new ServiceException.PreconditionRequired("GitHub accessToken does not have required scopes. Expected scopes 'user:email, repo'", (Throwable)ex);
                }
            }
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public ScmServerEndpointContainer getServers() {
        return null;
    }

    public boolean isOrganizationAvatarSupported() {
        return true;
    }

    @NonNull
    protected String createCredentialId(@NonNull String apiUrl) {
        return GithubCredentialUtils.computeCredentialId(null, ID, apiUrl);
    }

    @NonNull
    protected String getCredentialDescription() {
        return CREDENTIAL_DESCRIPTION;
    }

    @NonNull
    protected String getCustomApiUri() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Objects.requireNonNull(request, "Must be called in HTTP request context");
        String apiUri = request.getParameter("apiUrl");
        if (!StringUtils.isEmpty((CharSequence)apiUri)) {
            try {
                new URI(apiUri);
            }
            catch (URISyntaxException ex) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Invalid URI: " + apiUri));
            }
            apiUri = GithubScm.normalizeUrl(apiUri);
        } else {
            apiUri = "";
        }
        return apiUri;
    }

    static String normalizeUrl(@NonNull String apiUrl) {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        return apiUrl;
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        String accessToken = (String)request.get("accessToken");
        if (accessToken == null) {
            throw new ServiceException.BadRequestException("accessToken is required");
        }
        accessToken = accessToken.trim();
        try {
            Mailer.UserProperty p;
            User authenticatedUser = this.getAuthenticatedUser();
            this.checkPermission();
            HttpURLConnection connection = GithubScm.connect(String.format("%s/%s", this.getUri(), USER_SCOPE), accessToken);
            GithubScm.validateAccessTokenScopes(connection);
            String data = IOUtils.toString((InputStream)HttpRequest.getInputStream(connection), (Charset)Charset.defaultCharset());
            GHUser user = (GHUser)GithubScm.getMappingObjectReader().forType(GHUser.class).readValue(data);
            if (user.getEmail() != null && (p = (Mailer.UserProperty)authenticatedUser.getProperty(Mailer.UserProperty.class)) == null) {
                authenticatedUser.addProperty((UserProperty)new Mailer.UserProperty(user.getEmail()));
            }
            String credentialId = this.createCredentialId(this.getUri());
            StandardUsernamePasswordCredentials githubCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
            UsernamePasswordCredentialsImpl credential = new UsernamePasswordCredentialsImpl(CredentialsScope.USER, credentialId, this.getCredentialDescription(), authenticatedUser.getId(), accessToken);
            if (githubCredential == null) {
                CredentialsUtils.createCredentialsInUserStore((Credentials)credential, (User)authenticatedUser, (String)this.getCredentialDomainName(), Collections.singletonList(new BlueOceanDomainSpecification()));
            } else {
                CredentialsUtils.updateCredentialsInUserStore((Credentials)githubCredential, (Credentials)credential, (User)authenticatedUser, (String)this.getCredentialDomainName(), Collections.singletonList(new BlueOceanDomainSpecification()));
            }
            return this.createResponse(credential.getId());
        }
        catch (IOException e) {
            if (e instanceof MalformedURLException || e instanceof UnknownHostException) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Invalid apiUrl").add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage())));
            }
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
    }

    protected static HttpURLConnection connect(String apiUrl, String accessToken) throws IOException {
        HttpURLConnection connection = HttpRequest.get(apiUrl).withAuthorizationToken(accessToken).connect();
        int status = connection.getResponseCode();
        if (status == 401) {
            throw new ServiceException.PreconditionRequired("Invalid accessToken");
        }
        if (status == 403) {
            throw new ServiceException.PreconditionRequired("GitHub accessToken does not have required scopes. Expected scopes 'user:email, repo'");
        }
        if (status == 404) {
            throw new ServiceException.NotFoundException(String.format("Remote server at %s responded with code 404.", apiUrl));
        }
        if (status != 200) {
            throw new ServiceException.BadRequestException(String.format("GitHub Api returned error: %s. Error message: %s.", connection.getResponseCode(), connection.getResponseMessage()));
        }
        return connection;
    }

    protected void validateExistingAccessToken() {
        String credentialId = this.createCredentialId(this.getUri());
        StandardUsernamePasswordCredentials githubCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (githubCredential != null) {
            HttpURLConnection connection;
            try {
                connection = GithubScm.connect(String.format("%s/%s", this.getUri(), USER_SCOPE), githubCredential.getPassword().getPlainText());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            GithubScm.validateAccessTokenScopes(connection);
        }
    }

    static void validateAccessTokenScopes(HttpURLConnection connection) {
        String scopesHeader = connection.getHeaderField("X-OAuth-Scopes");
        if (scopesHeader == null) {
            throw new ServiceException.PreconditionRequired("No scopes associated with this token. Expected scopes 'user:email, repo'.");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (String s : scopesHeader.split(",")) {
            scopes.add(s.trim());
        }
        ArrayList<String> missingScopes = new ArrayList<String>();
        if (!scopes.contains(USER_EMAIL_SCOPE) && !scopes.contains(USER_SCOPE)) {
            missingScopes.add(USER_EMAIL_SCOPE);
        }
        if (!scopes.contains(REPO_SCOPE)) {
            missingScopes.add(REPO_SCOPE);
        }
        if (!missingScopes.isEmpty()) {
            throw new ServiceException.PreconditionRequired("Invalid token, its missing scopes: " + StringUtils.join(missingScopes, (String)","));
        }
    }

    static void validateUserHasPushPermission(@NonNull String apiUrl, @Nullable String accessToken, @Nullable String owner, @Nullable String repoName) {
        GHRepository repo;
        try {
            repo = HttpRequest.get(String.format("%s/repos/%s/%s", apiUrl, owner, repoName)).withAuthorizationToken(accessToken).to(GHRepository.class);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Could not load repository metadata for %s/%s", owner, repoName), (Throwable)e);
        }
        if (!repo.hasPushAccess()) {
            throw new ServiceException.PreconditionRequired(String.format("You do not have permission to push changes to %s/%s", owner, repoName));
        }
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(@NonNull String id, @NonNull Reachable parent) {
            if (id.equals(GithubScm.ID)) {
                return new GithubScm(parent);
            }
            return null;
        }

        @NonNull
        public Scm getScm(Reachable parent) {
            return new GithubScm(parent);
        }
    }
}

