/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubEnterpriseScm;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubFile;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScmSaveFileRequest;
import io.jenkins.blueocean.blueocean_github_pipeline.HttpRequest;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.ScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.GitContent;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmContentProviderParams;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=-100.0)
public class GithubScmContentProvider
extends AbstractScmContentProvider {
    @NonNull
    public String getScmId() {
        return "github";
    }

    public String getApiUrl(@NonNull Item item) {
        List sources;
        if (item instanceof OrganizationFolder) {
            List navigators = ((OrganizationFolder)item).getSCMNavigators();
            if (!navigators.isEmpty() && navigators.get(0) instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)navigators.get(0)).getApiUri();
            }
        } else if (item instanceof MultiBranchProject && !(sources = ((MultiBranchProject)item).getSCMSources()).isEmpty() && sources.get(0) instanceof GitHubSCMSource) {
            return ((GitHubSCMSource)sources.get(0)).getApiUri();
        }
        return null;
    }

    protected Object getContent(AbstractScmContentProvider.ScmGetRequest request) {
        GithubScm.validateUserHasPushPermission(request.getApiUrl(), request.getCredentials().getPassword().getPlainText(), request.getOwner(), request.getRepo());
        String url = String.format("%s/repos/%s/%s/contents/%s", request.getApiUrl(), request.getOwner(), request.getRepo(), request.getPath());
        if (request.getBranch() != null) {
            url = url + "?ref=" + request.getBranch();
        }
        try {
            Map ghContent = HttpRequest.get(url).withAuthorizationToken(request.getCredentials().getPassword().getPlainText()).to(Map.class);
            if (ghContent == null) {
                throw new ServiceException.UnexpectedErrorException("Failed to load file: " + request.getPath());
            }
            String base64Data = (String)ghContent.get("content");
            base64Data = base64Data == null ? null : base64Data.replace("\n", "");
            return new GithubFile(new GitContent.Builder().sha((String)ghContent.get("sha")).name((String)ghContent.get("name")).repo(request.getRepo()).owner(request.getOwner()).path(request.getPath()).base64Data(base64Data).build());
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Failed to load file %s: %s", request.getPath(), e.getMessage()), (Throwable)e);
        }
    }

    protected ScmContentProviderParams getScmParamsFromItem(Item item) {
        return new GithubScmParamsFromItem(item);
    }

    public Object saveContent(@NonNull StaplerRequest staplerRequest, @NonNull Item item) {
        JSONObject body;
        try {
            body = JSONObject.fromObject((Object)IOUtils.toString((Reader)staplerRequest.getReader()));
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to read request body");
        }
        body.put("$class", (Object)"io.jenkins.blueocean.blueocean_github_pipeline.GithubScmSaveFileRequest");
        GithubScmSaveFileRequest request = (GithubScmSaveFileRequest)staplerRequest.bindJSON(GithubScmSaveFileRequest.class, body);
        if (request == null) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to bind request"));
        }
        ScmContentProvider scmContentProvider = ScmContentProvider.resolve((Item)item);
        if (scmContentProvider != null) {
            return this.saveContent(request, item);
        }
        throw new ServiceException.BadRequestException("No save scm content provider found for pipeline: " + item.getFullName());
    }

    private Object saveContent(@NonNull GithubScmSaveFileRequest githubRequest, @NonNull Item item) {
        GithubScmParamsFromItem scmParamsFromItem = new GithubScmParamsFromItem(item);
        String owner = scmParamsFromItem.getOwner();
        String repo = scmParamsFromItem.getRepo();
        String accessToken = scmParamsFromItem.getCredentials().getPassword().getPlainText();
        Objects.requireNonNull(scmParamsFromItem.getApiUrl(), String.format("Project %s is not setup with Github api URL", item.getFullName()));
        return githubRequest.save(scmParamsFromItem.getApiUrl(), owner, repo, accessToken);
    }

    public boolean support(@NonNull Item item) {
        if (this.isItemUsingGithubScm(item)) {
            String apiUrl = this.getApiUrl(item);
            return apiUrl == null || apiUrl.startsWith("https://api.github.com");
        }
        return false;
    }

    protected boolean isItemUsingGithubScm(@NonNull Item item) {
        if (item instanceof MultiBranchProject) {
            List sources = ((MultiBranchProject)item).getSCMSources();
            return !sources.isEmpty() && sources.get(0) instanceof GitHubSCMSource;
        }
        return false;
    }

    private static class GithubScmParamsFromItem
    extends ScmContentProviderParams {
        private GithubScmParamsFromItem(Item item) {
            super(item);
            if (this.getCredentials() == null) {
                throw new ServiceException.BadRequestException(String.format("Pipeline %s is not configured with github source correctly, no credentials with github accessToken found", item.getFullName()));
            }
        }

        protected String owner(@NonNull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getRepoOwner();
            }
            return null;
        }

        protected String owner(@NonNull SCMNavigator scmNavigator) {
            if (scmNavigator instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)scmNavigator).getRepoOwner();
            }
            return null;
        }

        protected String repo(@NonNull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getRepository();
            }
            return null;
        }

        protected String apiUrl(@NonNull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getApiUri();
            }
            return null;
        }

        protected String apiUrl(@NonNull SCMNavigator scmNavigator) {
            if (scmNavigator instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)scmNavigator).getApiUri();
            }
            return null;
        }

        protected StandardUsernamePasswordCredentials getCredentialForUser(Item item, String apiUrl) {
            User user = User.current();
            if (user == null) {
                throw new ServiceException.UnauthorizedException("No logged in user found");
            }
            StaplerRequest request = Stapler.getCurrentRequest();
            String scmId = request.getParameter("scmId");
            BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg(item);
            GithubScm scm = apiUrl.startsWith("https://api.github.com") || StringUtils.isNotBlank((String)scmId) && scmId.equals("github") ? new GithubScm(() -> {
                Objects.requireNonNull(organization);
                return organization.getLink().rel("scm");
            }) : new GithubEnterpriseScm(() -> {
                Objects.requireNonNull(organization);
                return organization.getLink().rel("scm");
            });
            StandardUsernamePasswordCredentials githubCredential = scm.getCredential(GithubScm.normalizeUrl(apiUrl));
            if (githubCredential == null) {
                throw new ServiceException.PreconditionRequired("Can't access content from github: no credential found");
            }
            return githubCredential;
        }
    }
}

