/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.hash.Hashing;
import hudson.security.ACL;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubServer;
import io.jenkins.blueocean.blueocean_github_pipeline.HttpRequest;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpoint;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.kohsuke.stapler.json.JsonBody;

public class GithubServerContainer
extends ScmServerEndpointContainer {
    private static final Logger LOGGER = Logger.getLogger(GithubServerContainer.class.getName());
    static final String ERROR_MESSAGE_INVALID_SERVER = "Specified URL is not a GitHub server; check hostname";
    static final String ERROR_MESSAGE_INVALID_APIURL = "Specified URL is not a GitHub API endpoint; check path";
    private final Link parent;

    GithubServerContainer(Link parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public ScmServerEndpoint create(@JsonBody JSONObject request) {
        LinkedList errors;
        block20: {
            String url;
            String name;
            block19: {
                errors = Lists.newLinkedList();
                name = (String)request.get("name");
                if (StringUtils.isEmpty((CharSequence)name)) {
                    errors.add(new ErrorMessage.Error("name", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "name is required"));
                } else {
                    GithubServer byName = this.findByName(name);
                    if (byName != null) {
                        errors.add(new ErrorMessage.Error("name", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), "name already exists for server at '" + byName.getApiUrl() + "'"));
                    }
                }
                url = (String)request.get("apiUrl");
                if (StringUtils.isEmpty((CharSequence)url)) {
                    errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required"));
                } else {
                    Endpoint byUrl = GitHubConfiguration.get().findEndpoint(url);
                    if (byUrl != null) {
                        errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), "apiUrl is already registered as '" + byUrl.getName() + "'"));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    try {
                        HttpURLConnection connection = HttpRequest.get(url).connect();
                        if (connection.getHeaderField("X-GitHub-Request-Id") == null) {
                            errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), ERROR_MESSAGE_INVALID_SERVER));
                            break block19;
                        }
                        boolean isGithubCloud = false;
                        boolean isGithubEnterprise = false;
                        try {
                            int code = connection.getResponseCode();
                            InputStream inputStream = 200 <= code && code < 300 ? HttpRequest.getInputStream(connection) : HttpRequest.getErrorStream(connection);
                            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                            Map responseBody = (Map)GithubScm.getMappingObjectReader().forType((TypeReference)typeRef).readValue(inputStream);
                            isGithubCloud = code == 200 && responseBody.containsKey("current_user_url");
                            isGithubEnterprise = code == 401 && responseBody.containsKey("message");
                        }
                        catch (IOException | IllegalArgumentException ioe) {
                            LOGGER.log(Level.INFO, "Could not parse response body from Github");
                        }
                        if (!isGithubCloud && !isGithubEnterprise) {
                            errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), ERROR_MESSAGE_INVALID_APIURL));
                        }
                    }
                    catch (Throwable e) {
                        errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.toString()));
                        LOGGER.log(Level.INFO, "Could not connect to Github", e);
                    }
                }
            }
            if (errors.isEmpty()) {
                SecurityContext old = null;
                try {
                    old = ACL.impersonate((Authentication)ACL.SYSTEM);
                    GitHubConfiguration config = GitHubConfiguration.get();
                    String sanitizedUrl = this.discardQueryString(url);
                    Endpoint endpoint = new Endpoint(sanitizedUrl, name);
                    if (!config.addEndpoint(endpoint)) {
                        errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), "apiUrl is already registered as '" + endpoint.getName() + "'"));
                        break block20;
                    }
                    GithubServer githubServer = new GithubServer(endpoint, this.getLink());
                    return githubServer;
                }
                finally {
                    if (old != null) {
                        SecurityContextHolder.setContext((SecurityContext)old);
                    }
                }
            }
        }
        ErrorMessage message = new ErrorMessage(Integer.valueOf(400), "Failed to create GitHub server");
        message.addAll((Collection)errors);
        throw new ServiceException.BadRequestException(message);
    }

    public Link getLink() {
        return this.parent.rel("servers");
    }

    public GithubServer get(final String encodedApiUrl) {
        Endpoint endpoint = (Endpoint)Iterables.find((Iterable)GitHubConfiguration.get().getEndpoints(), (Predicate)new Predicate<Endpoint>(){

            public boolean apply(@Nullable Endpoint input) {
                return input != null && encodedApiUrl.equals(Hashing.sha256().hashString((CharSequence)input.getApiUri(), Charsets.UTF_8).toString());
            }
        }, null);
        if (endpoint == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return new GithubServer(endpoint, this.getLink());
    }

    public Iterator<ScmServerEndpoint> iterator() {
        List endpoints = Ordering.from((Comparator)new Comparator<Endpoint>(){

            @Override
            public int compare(Endpoint o1, Endpoint o2) {
                return ComparatorUtils.NATURAL_COMPARATOR.compare(o1.getName(), o2.getName());
            }
        }).sortedCopy((Iterable)GitHubConfiguration.get().getEndpoints());
        return Iterators.transform(endpoints.iterator(), (Function)new Function<Endpoint, ScmServerEndpoint>(){

            public ScmServerEndpoint apply(Endpoint input) {
                return new GithubServer(input, GithubServerContainer.this.getLink());
            }
        });
    }

    private String discardQueryString(String apiUrl) {
        if (apiUrl != null && apiUrl.contains("?")) {
            return apiUrl.substring(0, apiUrl.indexOf("?"));
        }
        return apiUrl;
    }

    private GithubServer findByName(final String name) {
        return (GithubServer)((Object)Iterators.find(this.iterator(), (Predicate)new Predicate<ScmServerEndpoint>(){

            public boolean apply(ScmServerEndpoint input) {
                return input.getName().equals(name);
            }
        }, null));
    }
}

