/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.RateLimitHandler;

class GitHubFactory {
    public static GitHub connect(String accessToken, String endpointUri) throws IOException {
        return new GitHubBuilder().withOAuthToken(accessToken).withRateLimitHandler((RateLimitHandler)RateLimitHandlerImpl.INSTANCE).withAbuseLimitHandler((AbuseLimitHandler)AbuseLimitHandlerImpl.INSTANCE).withEndpoint(endpointUri).build();
    }

    private GitHubFactory() {
    }

    static class AbuseLimitHandlerImpl
    extends AbuseLimitHandler {
        static final AbuseLimitHandlerImpl INSTANCE = new AbuseLimitHandlerImpl();

        AbuseLimitHandlerImpl() {
        }

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            throw new ServiceException.BadRequestException("API abuse limit reached. Message: " + e.getMessage(), (Throwable)e);
        }
    }

    static class RateLimitHandlerImpl
    extends RateLimitHandler {
        static final RateLimitHandlerImpl INSTANCE = new RateLimitHandlerImpl();

        RateLimitHandlerImpl() {
        }

        public void onError(IOException e, HttpURLConnection httpURLConnection) throws IOException {
            throw new ServiceException.BadRequestException("API rate limit reached. Message: " + e.getMessage(), (Throwable)e);
        }
    }
}

