/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import io.jenkins.blueocean.blueocean_github_pipeline.AbstractGithubOrganization;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubRespositoryContainer;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositoryContainer;
import org.kohsuke.github.GHOrganization;

public class GithubOrganization
extends AbstractGithubOrganization {
    private final GHOrganization ghOrganization;
    private final Link self;
    private final StandardUsernamePasswordCredentials credential;
    private final GithubScm scm;

    public GithubOrganization(GithubScm scm, GHOrganization ghOrganization, StandardUsernamePasswordCredentials credential, Link parent) {
        this.scm = scm;
        this.ghOrganization = ghOrganization;
        this.credential = credential;
        this.self = parent.rel(ghOrganization.getLogin());
    }

    public String getName() {
        return this.ghOrganization.getLogin();
    }

    public String getAvatar() {
        if (this.scm.isOrganizationAvatarSupported()) {
            return GithubOrganization.getAvatarWithSize(this.ghOrganization.getAvatarUrl());
        }
        return null;
    }

    public ScmRepositoryContainer getRepositories() {
        return new GithubRespositoryContainer(this.scm, this.ghOrganization.getUrl().toString(), this.getName(), this.credential, (Reachable)this);
    }

    public Link getLink() {
        return this.self;
    }
}

