/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.google.common.base.Preconditions;
import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubFile;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScmSaveFileRequest;
import io.jenkins.blueocean.blueocean_github_pipeline.HttpRequest;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.ScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.GitContent;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmContentProviderParams;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=-100.0)
public class GithubScmContentProvider
extends AbstractScmContentProvider {
    protected Object getContent(AbstractScmContentProvider.ScmGetRequest request) {
        GithubScm.validateUserHasPushPermission(request.getApiUrl(), request.getCredentials().getPassword().getPlainText(), request.getOwner(), request.getRepo());
        String url = String.format("%s/repos/%s/%s/contents/%s", request.getApiUrl(), request.getOwner(), request.getRepo(), request.getPath());
        if (request.getBranch() != null) {
            url = url + "?ref=" + request.getBranch();
        }
        try {
            Map ghContent = HttpRequest.get(url).withAuthorizationToken(request.getCredentials().getPassword().getPlainText()).to(Map.class);
            if (ghContent == null) {
                throw new ServiceException.UnexpectedErrorException("Failed to load file: " + request.getPath());
            }
            return new GithubFile(new GitContent.Builder().sha((String)ghContent.get("sha")).name((String)ghContent.get("name")).repo(request.getRepo()).owner(request.getOwner()).path(request.getPath()).base64Data((String)ghContent.get("content")).build());
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Failed to load file %s: %s", request.getPath(), e.getMessage()), (Throwable)e);
        }
    }

    protected ScmContentProviderParams getScmParamsFromItem(Item item) {
        return new GithubScmParamsFromItem(item);
    }

    public Object saveContent(@Nonnull StaplerRequest staplerRequest, @Nonnull Item item) {
        JSONObject body;
        try {
            body = JSONObject.fromObject((Object)IOUtils.toString((Reader)staplerRequest.getReader()));
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to read request body");
        }
        body.put("$class", (Object)"io.jenkins.blueocean.blueocean_github_pipeline.GithubScmSaveFileRequest");
        GithubScmSaveFileRequest request = (GithubScmSaveFileRequest)staplerRequest.bindJSON(GithubScmSaveFileRequest.class, body);
        if (request == null) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to bind request"));
        }
        ScmContentProvider scmContentProvider = ScmContentProvider.resolve((Item)item);
        if (scmContentProvider != null) {
            return this.saveContent(request, item);
        }
        throw new ServiceException.BadRequestException("No save scm content provider found for pipeline: " + item.getFullName());
    }

    private Object saveContent(@Nonnull GithubScmSaveFileRequest githubRequest, @Nonnull Item item) {
        GithubScmParamsFromItem scmParamsFromItem = new GithubScmParamsFromItem(item);
        String owner = scmParamsFromItem.getOwner();
        String repo = scmParamsFromItem.getRepo();
        String accessToken = scmParamsFromItem.getCredentials().getPassword().getPlainText();
        Preconditions.checkNotNull((Object)scmParamsFromItem.getApiUrl(), (Object)String.format("Project %s is not setup with Github api URL", item.getFullName()));
        return githubRequest.save(scmParamsFromItem.getApiUrl(), owner, repo, accessToken);
    }

    public boolean support(@Nonnull Item item) {
        if (item instanceof OrganizationFolder) {
            List navigators = ((OrganizationFolder)item).getSCMNavigators();
            return !navigators.isEmpty() && navigators.get(0) instanceof GitHubSCMNavigator;
        }
        if (item instanceof MultiBranchProject) {
            List sources = ((MultiBranchProject)item).getSCMSources();
            return !sources.isEmpty() && sources.get(0) instanceof GitHubSCMSource;
        }
        return false;
    }

    private static class GithubScmParamsFromItem
    extends ScmContentProviderParams {
        private GithubScmParamsFromItem(Item item) {
            super(item);
            if (this.getCredentials() == null) {
                throw new ServiceException.BadRequestException(String.format("Pipeline %s is not configured with github source correctly, no credentials with github accessToken found", item.getFullName()));
            }
        }

        protected String owner(@Nonnull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getRepoOwner();
            }
            return null;
        }

        protected String owner(@Nonnull SCMNavigator scmNavigator) {
            if (scmNavigator instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)scmNavigator).getRepoOwner();
            }
            return null;
        }

        protected String repo(@Nonnull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getRepository();
            }
            return null;
        }

        protected String apiUrl(@Nonnull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getApiUri();
            }
            return null;
        }

        protected String apiUrl(@Nonnull SCMNavigator scmNavigator) {
            if (scmNavigator instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)scmNavigator).getApiUri();
            }
            return null;
        }

        protected String credentialId(@Nonnull SCMSource scmSource) {
            if (scmSource instanceof GitHubSCMSource) {
                return ((GitHubSCMSource)scmSource).getScanCredentialsId();
            }
            return null;
        }

        protected String credentialId(@Nonnull SCMNavigator scmNavigator) {
            if (scmNavigator instanceof GitHubSCMNavigator) {
                return ((GitHubSCMNavigator)scmNavigator).getScanCredentialsId();
            }
            return null;
        }
    }
}

