/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubOrganization;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubUserOrganization;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainSpecification;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.json.JsonBody;

public class GithubScm
extends Scm {
    private static final String ID = "github";
    private static final String USER_EMAIL_SCOPE = "user:email";
    private static final String USER_SCOPE = "user";
    private static final String REPO_SCOPE = "repo";
    static final String DOMAIN_NAME = "blueocean-github-domain";
    static final String CREDENTIAL_DESCRIPTION = "GitHub Access Token";
    private final Link self;
    static final ObjectMapper om = new ObjectMapper();

    public GithubScm(Reachable parent) {
        this.self = parent.getLink().rel(ID);
    }

    public Link getLink() {
        return this.self;
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public String getUri() {
        String apiUri = this.getCustomApiUri();
        if (!StringUtils.isEmpty((CharSequence)apiUri)) {
            return apiUri;
        }
        return "https://api.github.com";
    }

    public String getCredentialDomainName() {
        return DOMAIN_NAME;
    }

    public String getCredentialId() {
        StandardUsernamePasswordCredentials githubCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)this.getId(), StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (githubCredential != null) {
            return githubCredential.getId();
        }
        return null;
    }

    public Container<ScmOrganization> getOrganizations() {
        StaplerRequest request = Stapler.getCurrentRequest();
        String credentialId = GithubScm.getCredentialIdFromRequest(request);
        User authenticatedUser = GithubScm.getAuthenticatedUser();
        StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (credential == null) {
            throw new ServiceException.BadRequestException(String.format("Credential id: %s not found for user %s", credentialId, authenticatedUser.getId()));
        }
        String accessToken = credential.getPassword().getPlainText();
        try {
            GitHub github = new GitHubBuilder().withOAuthToken(accessToken).withRateLimitHandler((RateLimitHandler)new RateLimitHandlerImpl()).withEndpoint(this.getUri()).build();
            final Link link = this.getLink().rel("organizations");
            HashMap orgMap = new LinkedHashMap();
            for (Map.Entry entry : github.getMyOrganizations().entrySet()) {
                orgMap.put(entry.getKey(), new GithubOrganization(this, (GHOrganization)entry.getValue(), credential, link));
            }
            GHMyself user = github.getMyself();
            if (orgMap.get(user.getLogin()) == null) {
                orgMap = new HashMap(orgMap);
                orgMap.put(user.getLogin(), new GithubUserOrganization(user, credential, this));
            }
            final LinkedHashMap orgs = orgMap;
            return new Container<ScmOrganization>(){

                public ScmOrganization get(String name) {
                    ScmOrganization org = (ScmOrganization)orgs.get(name);
                    if (org == null) {
                        throw new ServiceException.NotFoundException(String.format("GitHub organization %s not found", name));
                    }
                    return org;
                }

                public Link getLink() {
                    return link;
                }

                public Iterator<ScmOrganization> iterator() {
                    return orgs.values().iterator();
                }
            };
        }
        catch (IOException e) {
            if (e instanceof HttpException) {
                HttpException ex = (HttpException)e;
                if (ex.getResponseCode() == 401) {
                    throw new ServiceException.PreconditionRequired("Invalid Github accessToken", (Throwable)ex);
                }
                if (ex.getResponseCode() == 403) {
                    throw new ServiceException.PreconditionRequired("Github accessToken does not have required scopes. Expected scopes 'user:email, repo'", (Throwable)ex);
                }
            }
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    protected String createCredentialId(@Nonnull String apiUrl) {
        return ID;
    }

    @Nonnull
    protected String getCredentialDescription() {
        return CREDENTIAL_DESCRIPTION;
    }

    @Nonnull
    protected String getCustomApiUri() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Preconditions.checkNotNull((Object)request, (Object)"Must be called in HTTP request context");
        String apiUri = request.getParameter("apiUrl");
        if (!StringUtils.isEmpty((CharSequence)apiUri)) {
            try {
                new URI(apiUri);
            }
            catch (URISyntaxException ex) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Invalid URI: " + apiUri));
            }
            if (apiUri.endsWith("/")) {
                apiUri = apiUri.substring(0, apiUri.length() - 1);
            }
        } else {
            apiUri = "";
        }
        return apiUri;
    }

    private static String getCredentialIdFromRequest(StaplerRequest request) {
        String credentialId = request.getParameter("credentialId");
        if (credentialId == null) {
            credentialId = request.getHeader("X-CREDENTIAL-NAME");
        }
        if (credentialId == null) {
            throw new ServiceException.BadRequestException("Missing credential id. It must be provided either as HTTP header: X-CREDENTIAL-NAME or as query parameter 'credentialId'");
        }
        return credentialId;
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        String accessToken = (String)request.get("accessToken");
        if (accessToken == null) {
            throw new ServiceException.BadRequestException("accessToken is required");
        }
        try {
            Mailer.UserProperty p;
            User authenticatedUser = GithubScm.getAuthenticatedUser();
            HttpURLConnection connection = GithubScm.connect(String.format("%s/%s", this.getUri(), USER_SCOPE), accessToken);
            GithubScm.validateAccessTokenScopes(connection);
            String data = IOUtils.toString((InputStream)connection.getInputStream());
            GHUser user = (GHUser)om.readValue(data, GHUser.class);
            if (user.getEmail() != null && (p = (Mailer.UserProperty)authenticatedUser.getProperty(Mailer.UserProperty.class)) == null) {
                authenticatedUser.addProperty((UserProperty)new Mailer.UserProperty(user.getEmail()));
            }
            String credentialId = this.createCredentialId(this.getUri());
            StandardUsernamePasswordCredentials githubCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
            UsernamePasswordCredentialsImpl credential = new UsernamePasswordCredentialsImpl(CredentialsScope.USER, credentialId, this.getCredentialDescription(), authenticatedUser.getId(), accessToken);
            if (githubCredential == null) {
                CredentialsUtils.createCredentialsInUserStore((Credentials)credential, (User)authenticatedUser, (String)this.getCredentialDomainName(), (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            } else {
                CredentialsUtils.updateCredentialsInUserStore((Credentials)githubCredential, (Credentials)credential, (User)authenticatedUser, (String)this.getCredentialDomainName(), (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            }
            return this.createResponse(credential.getId());
        }
        catch (IOException e) {
            if (e instanceof MalformedURLException || e instanceof UnknownHostException) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Invalid apiUrl").add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage())));
            }
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
    }

    static HttpURLConnection connect(String apiUrl, String accessToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(apiUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-type", "application/json");
        connection.setRequestProperty("Authorization", "token " + accessToken);
        connection.connect();
        int status = connection.getResponseCode();
        if (status == 401) {
            throw new ServiceException.PreconditionRequired("Invalid accessToken");
        }
        if (status == 403) {
            throw new ServiceException.PreconditionRequired("Github accessToken does not have required scopes. Expected scopes 'user:email, repo'");
        }
        if (status == 404) {
            throw new ServiceException.NotFoundException("Not Found");
        }
        if (status != 200) {
            throw new ServiceException.BadRequestException(String.format("Github Api returned error: %s. Error message: %s.", connection.getResponseCode(), connection.getResponseMessage()));
        }
        return connection;
    }

    static void validateAccessTokenScopes(HttpURLConnection connection) {
        String scopesHeader = connection.getHeaderField("X-OAuth-Scopes");
        if (scopesHeader == null) {
            throw new ServiceException.PreconditionRequired("No scopes associated with this token. Expected scopes 'user:email, repo'.");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (String s : scopesHeader.split(",")) {
            scopes.add(s.trim());
        }
        ArrayList<String> missingScopes = new ArrayList<String>();
        if (!scopes.contains(USER_EMAIL_SCOPE) && !scopes.contains(USER_SCOPE)) {
            missingScopes.add(USER_EMAIL_SCOPE);
        }
        if (!scopes.contains(REPO_SCOPE)) {
            missingScopes.add(REPO_SCOPE);
        }
        if (!missingScopes.isEmpty()) {
            throw new ServiceException.PreconditionRequired("Invalid token, its missing scopes: " + StringUtils.join(missingScopes, (String)","));
        }
    }

    private HttpResponse createResponse(final String credentialId) {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.getWriter().print(JsonConverter.toJson((Object)ImmutableMap.of((Object)"credentialId", (Object)credentialId)));
            }
        };
    }

    static User getAuthenticatedUser() {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        return authenticatedUser;
    }

    static {
        om.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(@Nonnull String id, @Nonnull Reachable parent) {
            if (id.equals(GithubScm.ID)) {
                return new GithubScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GithubScm(parent);
        }
    }

    static class RateLimitHandlerImpl
    extends RateLimitHandler {
        RateLimitHandlerImpl() {
        }

        public void onError(IOException e, HttpURLConnection httpURLConnection) throws IOException {
            throw new ServiceException.BadRequestException("API rate limit reached." + e.getMessage(), (Throwable)e);
        }
    }
}

