/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.fasterxml.jackson.databind.JsonMappingException;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.HttpConnector;

class HttpRequest {
    private final String method;
    private final String url;
    private String contentType = "application/json; charset=utf-8";
    private Object body;
    private String authorization;

    private HttpRequest(String method, String url) {
        this.method = method;
        this.url = url;
    }

    public static HttpRequest get(String url) {
        return new HttpRequest("GET", url);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest("HEAD", url);
    }

    public static HttpRequest post(String url) {
        return new HttpRequest("POST", url);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest("PUT", url);
    }

    public HttpRequest with(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public HttpRequest withAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public HttpRequest withBody(Object body) {
        this.body = body;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T to(Class<T> type) throws IOException {
        block15: {
            connection = this.connect();
            if (this.methodNeedsBody()) {
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-type", this.contentType);
                if (this.body == null) {
                    GithubScm.om.writeValue(connection.getOutputStream(), Collections.emptyMap());
                } else {
                    GithubScm.om.writeValue(connection.getOutputStream(), this.body);
                }
            }
            r = null;
            status = connection.getResponseCode();
            if (status == 304) {
                var5_5 = null;
            }
            ** GOTO lbl-1000
            {
                block14: {
                    catch (Throwable var7_10) {
                        IOUtils.closeQuietly(r);
                        throw var7_10;
                    }
                    IOUtils.closeQuietly(r);
                    return var5_5;
lbl-1000:
                    // 1 sources

                    {
                        if (status != 204 || type == null || !type.isArray()) break block14;
                        var5_6 = type.cast(Array.newInstance(type.getComponentType(), 0));
                    }
                    IOUtils.closeQuietly(r);
                    return var5_6;
                }
                if (status == 401) throw new ServiceException.ForbiddenException("Invalid accessToken");
                if (status == 403) {
                    throw new ServiceException.ForbiddenException("Invalid accessToken");
                }
                if (status == 404) {
                    throw new ServiceException.NotFoundException("Not Found: " + this.getErrorResponse(connection));
                }
                if (status > 399) {
                    throw new ServiceException.BadRequestExpception(String.format("%s %s returned error: %s. Error message: %s.", new Object[]{this.method, this.url, status, this.getErrorResponse(connection)}));
                }
                if (this.method.equals("HEAD")) break block15;
                r = new InputStreamReader(this.wrapStream(connection.getInputStream(), connection.getContentEncoding()), "UTF-8");
                data = IOUtils.toString((Reader)r);
                if (type == null) break block15;
                try {
                    var6_8 = GithubScm.om.readValue(data, type);
                }
                catch (JsonMappingException e) {}
                IOUtils.closeQuietly((Reader)r);
                return (T)var6_8;
                {
                    throw new IOException("Failed to deserialize " + data, e);
                }
            }
        }
        IOUtils.closeQuietly(r);
        return null;
    }

    private String getErrorResponse(HttpURLConnection connection) throws IOException {
        if (connection.getErrorStream() == null) {
            return "";
        }
        return IOUtils.toString((InputStream)this.wrapStream(connection.getErrorStream(), connection.getContentEncoding()));
    }

    private boolean methodNeedsBody() {
        return !this.method.equals("GET") && !this.method.equals("DELETE");
    }

    private HttpURLConnection connect() throws IOException {
        HttpURLConnection connect = HttpConnector.DEFAULT.connect(new URL(this.url));
        if (this.authorization != null) {
            connect.setRequestProperty("Authorization", this.authorization);
        }
        connect.setRequestMethod(this.method);
        connect.setRequestProperty("Accept-Encoding", "gzip");
        connect.setDoOutput(true);
        connect.setRequestProperty("Content-type", this.contentType);
        return connect;
    }

    private InputStream wrapStream(InputStream in, String contentEncoding) throws IOException {
        if (contentEncoding == null || in == null) {
            return in;
        }
        if (contentEncoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + contentEncoding);
    }
}

