/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubOrganizationFolder;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineCreateRequestImpl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.branch.CustomOrganizationFolderDescriptor;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.SimpleMessage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubPipelineCreateRequest
extends AbstractPipelineCreateRequestImpl {
    private static final String DESCRIPTOR = "jenkins.branch.OrganizationFolder.org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator";
    private static final Logger logger = LoggerFactory.getLogger(GithubPipelineCreateRequest.class);
    private BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GithubPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        this.scmConfig = scmConfig;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Runtime exception is thrown from the catch block")
    public BluePipeline create(Reachable parent) throws IOException {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent passed is null");
        Preconditions.checkNotNull((Object)this.getName(), (Object)"Name provided was null");
        String apiUrl = null;
        String orgName = this.getName();
        String credentialId = null;
        ArrayList<String> repos = new ArrayList<String>();
        if (this.scmConfig != null) {
            apiUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.scmConfig.getUri(), (CharSequence)"https://api.github.com");
            if (this.scmConfig.getConfig().get("orgName") instanceof String) {
                orgName = (String)this.scmConfig.getConfig().get("orgName");
            }
            credentialId = this.scmConfig.getCredentialId();
            if (this.scmConfig.getConfig().get("repos") instanceof List) {
                for (String r : (List)this.scmConfig.getConfig().get("repos")) {
                    repos.add(r);
                }
            }
        }
        String singleRepo = repos.size() == 1 ? (String)repos.get(0) : null;
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("Must login to create a pipeline");
        }
        Item item = Jenkins.getInstance().getItemByFullName(orgName);
        boolean creatingNewItem = item == null;
        try {
            if (credentialId != null) {
                GithubPipelineCreateRequest.validateCredentialId(credentialId, apiUrl);
            }
            if (item == null) {
                item = this.create((ModifiableTopLevelItemGroup)Jenkins.getInstance(), this.getName(), DESCRIPTOR, CustomOrganizationFolderDescriptor.class);
            }
            if (item instanceof OrganizationFolder) {
                if (credentialId != null) {
                    Domain domain = CredentialsUtils.findDomain((String)credentialId, (User)authenticatedUser);
                    if (domain == null) {
                        throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline").add(new ErrorMessage.Error("scm.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "No domain in user credentials found for credentialId: " + this.scmConfig.getCredentialId())));
                    }
                    if (domain.test(new DomainRequirement[]{new BlueOceanDomainRequirement()})) {
                        ((OrganizationFolder)item).addProperty((AbstractFolderProperty)new BlueOceanCredentialsProvider.FolderPropertyImpl(authenticatedUser.getId(), credentialId, BlueOceanCredentialsProvider.createDomain((String)apiUrl)));
                    }
                }
                OrganizationFolder organizationFolder = (OrganizationFolder)item;
                GitHubSCMNavigator gitHubSCMNavigator = (GitHubSCMNavigator)organizationFolder.getNavigators().get(GitHubSCMNavigator.class);
                StringBuilder sb = new StringBuilder();
                if (gitHubSCMNavigator != null) {
                    Matcher matcher = Pattern.compile("\\((.*?)\\\\b\\)\\?").matcher(gitHubSCMNavigator.getPattern());
                    while (matcher.find()) {
                        String string = matcher.group(1);
                        if (repos.contains(string)) continue;
                        repos.add(string);
                    }
                    for (MultiBranchProject p : organizationFolder.getItems()) {
                        if (repos.contains(p.getName())) continue;
                        repos.add(p.getName());
                    }
                    if (credentialId == null) {
                        credentialId = gitHubSCMNavigator.getScanCredentialsId();
                    }
                }
                gitHubSCMNavigator = new GitHubSCMNavigator(apiUrl, orgName, credentialId, credentialId);
                organizationFolder.getNavigators().replace((Describable)gitHubSCMNavigator);
                for (String string : repos) {
                    sb.append(String.format("(%s\\b)?", string));
                }
                if (sb.length() > 0) {
                    gitHubSCMNavigator.setPattern(sb.toString());
                }
                GithubOrganizationFolder githubOrganizationFolder = new GithubOrganizationFolder(organizationFolder, parent.getLink());
                if (singleRepo != null) {
                    final boolean bl = GithubPipelineCreateRequest.repoHasJenkinsFile(apiUrl, credentialId, orgName, singleRepo, organizationFolder);
                    if (bl) {
                        SCMSourceEvent.fireNow((SCMSourceEvent)new SCMSourceEventImpl(singleRepo, item, apiUrl, gitHubSCMNavigator));
                        this.sendMultibranchIndexingCompleteEvent(item, organizationFolder, singleRepo, 5);
                    } else {
                        this.sendOrganizationScanCompleteEvent(item, organizationFolder);
                    }
                    githubOrganizationFolder.addRepo(singleRepo, new GithubOrganizationFolder.BlueRepositoryProperty(){

                        @Override
                        public boolean meetsIndexingCriteria() {
                            return bl;
                        }
                    });
                } else {
                    gitHubSCMNavigator.setPattern(".*");
                    organizationFolder.scheduleBuild((Cause)new Cause.UserIdCause());
                }
                organizationFolder.save();
                return githubOrganizationFolder;
            }
        }
        catch (Exception e) {
            return GithubPipelineCreateRequest.cleanupOnError(e, this.getName(), item, creatingNewItem);
        }
        return null;
    }

    static BluePipeline cleanupOnError(Exception e, String name, Item item, boolean creatingNewItem) throws IOException {
        String msg = String.format("Error creating pipeline %s: %s", name, e.getMessage());
        logger.error(msg, (Throwable)e);
        if (item != null && creatingNewItem) {
            try {
                item.delete();
            }
            catch (InterruptedException e1) {
                logger.error(String.format("Error creating pipeline %s: %s", name, e1.getMessage()), (Throwable)e1);
                throw new ServiceException.UnexpectedErrorException("Error cleaning up pipeline " + name + " due to error: " + e.getMessage(), (Throwable)e);
            }
        }
        if (e instanceof ServiceException) {
            throw (ServiceException)e;
        }
        throw new ServiceException.UnexpectedErrorException(msg, (Throwable)e);
    }

    private void sendOrganizationScanCompleteEvent(final Item item, final OrganizationFolder orgFolder) {
        Executors.newScheduledThreadPool(1).schedule(new Runnable(){

            @Override
            public void run() {
                GithubPipelineCreateRequest.this._sendOrganizationScanCompleteEvent(item, orgFolder);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void _sendOrganizationScanCompleteEvent(Item item, OrganizationFolder orgFolder) {
        try {
            SimpleMessage msg = new SimpleMessage();
            msg.set("jenkins_object_type", "jenkins.branch.OrganizationFolder");
            msg.set("job_run_status", "ALLOCATED");
            msg.set("job_name", orgFolder.getName());
            msg.set("jenkins_org", "jenkins");
            msg.set("job_orgfolder_indexing_status", "COMPLETE");
            msg.set("job_run_queueId", "1");
            msg.set("jenkins_object_name", orgFolder.getName());
            msg.set("blueocean_job_rest_url", "/blue/rest/organizations/jenkins/pipelines/" + orgFolder.getName() + "/");
            msg.set("jenkins_event", "job_run_queue_task_complete");
            msg.set("job_orgfolder_indexing_result", "SUCCESS");
            msg.set("blueocean_job_pipeline_name", orgFolder.getName());
            msg.set("jenkins_object_url", "job/" + orgFolder.getName() + "/");
            msg.set("jenkins_channel", "job");
            PubsubBus.getBus().publish((Message)msg);
        }
        catch (MessageException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMultibranchIndexingCompleteEvent(final Item item, final OrganizationFolder orgFolder, final String name, final int iterations) {
        Executors.newScheduledThreadPool(1).schedule(new Runnable(){

            @Override
            public void run() {
                GithubPipelineCreateRequest.this._sendMultibranchIndexingCompleteEvent(item, orgFolder, name, iterations);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void _sendMultibranchIndexingCompleteEvent(Item item, OrganizationFolder orgFolder, String name, int iterations) {
        MultiBranchProject mbp = orgFolder.getItem(name);
        if (mbp == null) {
            if (iterations <= 0) {
                return;
            }
            this.sendMultibranchIndexingCompleteEvent(item, orgFolder, name, iterations - 1);
            return;
        }
        try {
            String jobName = orgFolder.getName() + "/" + mbp.getName();
            SimpleMessage msg = new SimpleMessage();
            msg.set("jenkins_object_type", "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject");
            msg.set("job_run_status", "QUEUED");
            msg.set("job_name", jobName);
            msg.set("jenkins_org", "jenkins");
            msg.set("job_run_queueId", "11");
            msg.set("job_ismultibranch", "true");
            msg.set("jenkins_object_name", jobName);
            msg.set("blueocean_job_rest_url", "/blue/rest/organizations/jenkins/pipelines/" + orgFolder.getName() + "/pipelines/" + mbp.getName() + "/");
            msg.set("job_multibranch_indexing_status", "INDEXING");
            msg.set("jenkins_event", "job_run_queue_enter");
            msg.set("blueocean_job_pipeline_name", jobName);
            msg.set("jenkins_object_url", "job/" + orgFolder.getName() + "/job/" + mbp.getName() + "/");
            msg.set("jenkins_channel", "job");
            PubsubBus.getBus().publish((Message)msg);
        }
        catch (MessageException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean repoHasJenkinsFile(String apiUrl, String credentialId, String owner, String repo, OrganizationFolder sourceOwner) throws IOException, InterruptedException {
        GitHubSCMSource gitHubSCMSource = new GitHubSCMSource(null, apiUrl, credentialId, credentialId, owner, repo);
        gitHubSCMSource.setOwner((SCMSourceOwner)sourceOwner);
        final JenkinsfileCriteria criteria = new JenkinsfileCriteria();
        gitHubSCMSource.fetch((SCMSourceCriteria)criteria, new SCMHeadObserver(){

            public void observe(@Nonnull SCMHead head, @Nonnull SCMRevision revision) throws IOException, InterruptedException {
            }

            public boolean isObserving() {
                return !criteria.isJekinsfileFound();
            }
        }, TaskListener.NULL);
        return criteria.isJekinsfileFound();
    }

    static void validateCredentialId(String credentialId, String apiUrl) throws IOException {
        if (credentialId != null && !credentialId.trim().isEmpty()) {
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
            if (credentials == null) {
                throw new ServiceException.BadRequestExpception(new ErrorMessage(Integer.valueOf(400), "Failed to create Github pipeline").add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), "No Credentials instance found for credentialId: " + credentialId)));
            }
            String accessToken = credentials.getPassword().getPlainText();
            GithubPipelineCreateRequest.validateGithubAccessToken(accessToken, apiUrl);
        }
    }

    private static void deleteOnError(AbstractFolder item) {
        try {
            item.delete();
        }
        catch (IOException | InterruptedException e) {
            throw new ServiceException.UnexpectedErrorException("Failure during cleaning up folder: " + item.getName() + ". Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void validateGithubAccessToken(String accessToken, String apiUrl) throws IOException {
        try {
            HttpURLConnection connection = GithubScm.connect(apiUrl + "/user", accessToken);
            GithubScm.validateAccessTokenScopes(connection);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw e;
            }
            throw new ServiceException.UnexpectedErrorException("Failure validating github access token: " + e.getMessage(), (Throwable)e);
        }
    }

    private static class JenkinsfileCriteria
    implements SCMSourceCriteria {
        private static final long serialVersionUID = 1L;
        private AtomicBoolean jenkinsFileFound = new AtomicBoolean();

        private JenkinsfileCriteria() {
        }

        public boolean isHead(@Nonnull SCMSourceCriteria.Probe probe, @Nonnull TaskListener listener) throws IOException {
            boolean foundJekinsFile;
            SCMProbeStat stat = probe.stat("Jenkinsfile");
            boolean bl = foundJekinsFile = stat.getType() != SCMFile.Type.NONEXISTENT && stat.getType() != SCMFile.Type.DIRECTORY;
            if (foundJekinsFile && !this.jenkinsFileFound.get()) {
                this.jenkinsFileFound.set(true);
            }
            return foundJekinsFile;
        }

        private boolean isJekinsfileFound() {
            return this.jenkinsFileFound.get();
        }
    }

    static class SCMSourceEventImpl
    extends SCMSourceEvent<Object> {
        private final String repoName;
        private final Item project;
        private final GitHubSCMNavigator navigator;

        public SCMSourceEventImpl(String repoName, Item project, String origin, GitHubSCMNavigator navigator) {
            super(SCMEvent.Type.CREATED, new Object(), origin);
            this.repoName = repoName;
            this.project = project;
            this.navigator = navigator;
        }

        public boolean isMatch(@Nonnull SCMNavigator navigator) {
            return this.navigator == navigator;
        }

        public boolean isMatch(@Nonnull SCMSource source) {
            SCMSourceOwner sourceOwner = source.getOwner();
            return ((GitHubSCMSource)source).getRepository().equals(this.getSourceName()) && sourceOwner != null && sourceOwner.getFullName().equals(this.project.getFullName());
        }

        @Nonnull
        public String getSourceName() {
            return this.repoName;
        }
    }
}

