/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import hudson.Extension;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;

public class GithubEnterpriseScm
extends GithubScm {
    static final String DEFAULT_ENTERPRISE_API_SUFFIX = "/api/v3";
    static final String ID = "github-enterprise";
    static final String DOMAIN_NAME = "blueocean-github-enterprise-domain";

    public GithubEnterpriseScm(Reachable parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public String getId() {
        return ID;
    }

    @Override
    @Nonnull
    public String getUri() {
        return super.getUri() + DEFAULT_ENTERPRISE_API_SUFFIX;
    }

    @Override
    public String getCredentialDomainName() {
        URI uri;
        try {
            uri = new URI(this.getUri());
        }
        catch (URISyntaxException e) {
            throw new ServiceException.UnexpectedErrorException(new ErrorMessage(Integer.valueOf(400), "Invalid Github Enterprise URI: " + this.getUri()));
        }
        return "blueocean-github-enterprise-domain-" + uri.getHost();
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(String id, Reachable parent) {
            if (id.equals(GithubEnterpriseScm.ID)) {
                return new GithubEnterpriseScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GithubEnterpriseScm(parent);
        }
    }
}

