/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.HostnamePortSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.PathSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubOrganization;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubUserOrganization;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.json.JsonBody;

public class GithubScm
extends Scm {
    private static final String DEFAULT_API_URI = "https://api.github.com";
    private static final String ID = "github";
    private static final String USER_EMAIL_SCOPE = "user:email";
    private static final String USER_SCOPE = "user";
    private static final String REPO_SCOPE = "repo";
    private static final String DOMAIN_NAME = "github-domain";
    private final Link self;

    public GithubScm(Reachable parent) {
        this.self = parent.getLink().rel(ID);
    }

    public Link getLink() {
        return this.self;
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public String getUri() {
        return DEFAULT_API_URI;
    }

    public String getCredentialId() {
        StandardUsernamePasswordCredentials githubCredential = GithubScm.findUsernamePasswordCredential(this);
        if (githubCredential != null) {
            return githubCredential.getId();
        }
        return null;
    }

    public Container<ScmOrganization> getOrganizations() {
        StaplerRequest request = Stapler.getCurrentRequest();
        String credentialId = GithubScm.getCredentialIdFromRequest(request);
        StandardUsernamePasswordCredentials credential = GithubScm.findUsernamePasswordCredential(credentialId);
        if (credential == null) {
            String user = User.current() == null ? "anonymous" : User.current().getId();
            throw new ServiceException.BadRequestExpception(String.format("Credential id: %s not found for user %s", credentialId, user));
        }
        String accessToken = credential.getPassword().getPlainText();
        try {
            GitHub github = new GitHubBuilder().withOAuthToken(accessToken).withRateLimitHandler((RateLimitHandler)new RateLimitHandlerImpl()).withEndpoint(this.getUri()).build();
            final Link link = this.getLink().rel("organizations");
            HashMap orgMap = new LinkedHashMap();
            for (Map.Entry entry : github.getMyOrganizations().entrySet()) {
                orgMap.put(entry.getKey(), new GithubOrganization(this, (GHOrganization)entry.getValue(), credential, link));
            }
            GHMyself user = github.getMyself();
            if (orgMap.get(user.getLogin()) == null) {
                orgMap = new HashMap(orgMap);
                orgMap.put(user.getLogin(), new GithubUserOrganization(user, credential, this));
            }
            final LinkedHashMap orgs = orgMap;
            return new Container<ScmOrganization>(){

                public ScmOrganization get(String name) {
                    ScmOrganization org = (ScmOrganization)orgs.get(name);
                    if (org == null) {
                        throw new ServiceException.NotFoundException(String.format("GitHub organization %s not found", name));
                    }
                    return org;
                }

                public Link getLink() {
                    return link;
                }

                public Iterator<ScmOrganization> iterator() {
                    return orgs.values().iterator();
                }
            };
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getCredentialIdFromRequest(StaplerRequest request) {
        String credentialId = request.getParameter("credentialId");
        if (credentialId == null) {
            credentialId = request.getHeader("X-CREDENTIAL-NAME");
        }
        if (credentialId == null) {
            throw new ServiceException.BadRequestExpception("Missing credential id. It must be provided either as HTTP header: X-CREDENTIAL-NAME or as query parameter 'credentialId'");
        }
        return credentialId;
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        String accessToken = (String)request.get("accessToken");
        if (accessToken == null) {
            throw new ServiceException.BadRequestExpception("accessToken is required");
        }
        try {
            Mailer.UserProperty p;
            User authenticatedUser = User.current();
            if (authenticatedUser == null) {
                throw new ServiceException.UnauthorizedException("No authenticated user found");
            }
            HttpURLConnection connection = GithubScm.connect(String.format("%s/%s", this.getUri(), USER_SCOPE), accessToken);
            String scopesHeader = connection.getHeaderField("X-OAuth-Scopes");
            if (scopesHeader == null) {
                throw new ServiceException.ForbiddenException("No scopes associated with this token. Expected scopes 'user:email, repo'.");
            }
            ArrayList<String> scopes = new ArrayList<String>();
            for (String s : scopesHeader.split(",")) {
                scopes.add(s.trim());
            }
            ArrayList<String> missingScopes = new ArrayList<String>();
            if (!scopes.contains(USER_EMAIL_SCOPE) && !scopes.contains(USER_SCOPE)) {
                missingScopes.add(USER_EMAIL_SCOPE);
            }
            if (!scopes.contains(REPO_SCOPE)) {
                missingScopes.add(REPO_SCOPE);
            }
            if (!missingScopes.isEmpty()) {
                throw new ServiceException.ForbiddenException("Invalid token, its missing scopes: " + StringUtils.join(missingScopes, (String)","));
            }
            String data = IOUtils.toString((InputStream)connection.getInputStream());
            GHUser user = (GHUser)JsonConverter.toJava((String)data, GHUser.class);
            if (user.getEmail() != null && (p = (Mailer.UserProperty)authenticatedUser.getProperty(Mailer.UserProperty.class)) == null) {
                authenticatedUser.addProperty((UserProperty)new Mailer.UserProperty(user.getEmail()));
            }
            StandardUsernamePasswordCredentials githubCredential = GithubScm.findUsernamePasswordCredential(this);
            UsernamePasswordCredentialsImpl credential = new UsernamePasswordCredentialsImpl(CredentialsScope.USER, ID, "Github Access Token", user.getLogin(), accessToken);
            CredentialsStore store = null;
            for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)authenticatedUser)) {
                if (!s.hasPermission(CredentialsProvider.CREATE) || !s.hasPermission(CredentialsProvider.UPDATE)) continue;
                store = s;
                break;
            }
            if (store == null) {
                throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", authenticatedUser.getId()));
            }
            Domain domain = store.getDomainByName(DOMAIN_NAME);
            if (domain == null) {
                URI uri = new URI(this.getUri());
                ArrayList<Object> domainSpecifications = new ArrayList<Object>();
                String path = uri.getRawPath() == null ? null : (uri.getRawPath().trim().isEmpty() ? "/" : uri.getRawPath());
                domainSpecifications.add(new PathSpecification(path, "", false));
                if (uri.getPort() != -1) {
                    domainSpecifications.add(new HostnamePortSpecification(uri.getHost() + ":" + uri.getPort(), null));
                } else {
                    domainSpecifications.add(new HostnameSpecification(uri.getHost(), null));
                }
                domainSpecifications.add(new SchemeSpecification(uri.getScheme()));
                boolean result = store.addDomain(new Domain(DOMAIN_NAME, "Github Domain to store personal access token", domainSpecifications), new Credentials[0]);
                if (!result) {
                    throw new ServiceException.BadRequestExpception("Github accessToken is valid but no valid credential domain found and could not be created");
                }
                domain = store.getDomainByName(DOMAIN_NAME);
                if (domain == null) {
                    throw new ServiceException.BadRequestExpception("Github accessToken is valid but no valid credential domain found and could not be created");
                }
            }
            if (githubCredential == null) {
                if (!store.addCredentials(domain, (Credentials)credential)) {
                    throw new ServiceException.UnexpectedErrorException("Failed to add credential to domain");
                }
            } else if (!store.updateCredentials(domain, (Credentials)githubCredential, (Credentials)credential)) {
                throw new ServiceException.UnexpectedErrorException("Failed to update credential to domain");
            }
            return this.createResponse(credential.getId());
        }
        catch (IOException | URISyntaxException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
    }

    static HttpURLConnection connect(String apiUrl, String accessToken) throws IOException {
        HttpURLConnection connection = HttpConnector.DEFAULT.connect(new URL(apiUrl));
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-type", "application/json");
        connection.setRequestProperty("Authorization", "token " + accessToken);
        connection.connect();
        int status = connection.getResponseCode();
        if (status == 401 || status == 403) {
            throw new ServiceException.ForbiddenException("Invalid accessToken");
        }
        if (status == 404) {
            throw new ServiceException.NotFoundException("Not Found");
        }
        if (status != 200) {
            throw new ServiceException.BadRequestExpception(String.format("Github Api returned error: %s. Error message: %s.", connection.getResponseCode(), connection.getResponseMessage()));
        }
        return connection;
    }

    private Domain getFirstDomain(CredentialsStore store) {
        for (Domain d : store.getDomains()) {
            if (d.getName() == null) continue;
            return d;
        }
        return null;
    }

    private HttpResponse createResponse(final String credentialId) {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.getWriter().print(JsonConverter.toJson((Object)ImmutableMap.of((Object)"credentialId", (Object)credentialId)));
            }
        };
    }

    private static StandardUsernamePasswordCredentials findUsernamePasswordCredential(Scm scm) {
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)scm.getUri()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scm.getId()), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)})}));
    }

    @CheckForNull
    private static StandardUsernamePasswordCredentials findUsernamePasswordCredential(String id) {
        if (User.current() == null) {
            throw new ServiceException.UnauthorizedException("No authenticated user found. Please login");
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)})}));
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(@Nonnull String id, @Nonnull Reachable parent) {
            if (id.equals(GithubScm.ID)) {
                return new GithubScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GithubScm(parent);
        }
    }

    public static class RateLimitHandlerImpl
    extends RateLimitHandler {
        public void onError(IOException e, HttpURLConnection httpURLConnection) throws IOException {
            throw new ServiceException.BadRequestExpception("API rate limit reached." + e.getMessage(), (Throwable)e);
        }
    }
}

