/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Item;
import hudson.security.ACL;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubPipelineCreateRequest;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineUpdateRequest;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMNavigator;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.kohsuke.stapler.DataBoundConstructor;

public class GithubPipelineUpdateRequest
extends BluePipelineUpdateRequest {
    private final BlueScmConfig scmConfig;

    @DataBoundConstructor
    public GithubPipelineUpdateRequest(BlueScmConfig scmConfig) {
        this.scmConfig = scmConfig;
    }

    @Nonnull
    public BluePipeline update(BluePipeline pipeline) throws IOException {
        Authentication a;
        ACL acl = Jenkins.getInstance().getACL();
        if (!acl.hasPermission(a = Jenkins.getAuthentication(), Item.CONFIGURE)) {
            throw new ServiceException.ForbiddenException(String.format("Failed to update Git pipeline: %s. User %s doesn't have Job configure permission", pipeline.getName(), a.getName()));
        }
        Item item = Jenkins.getInstance().getItemByFullName(pipeline.getFullName());
        if (item instanceof OrganizationFolder) {
            OrganizationFolder folder = (OrganizationFolder)item;
            GitHubSCMNavigator gitHubSCMNavigator = this.getNavigator(folder);
            if (gitHubSCMNavigator != null) {
                folder.getNavigators().replace((Describable)gitHubSCMNavigator);
                folder.scheduleBuild((Cause)new Cause.UserIdCause());
            }
            return pipeline;
        }
        return null;
    }

    private GitHubSCMNavigator getNavigator(OrganizationFolder folder) throws IOException {
        String apiUrl = null;
        String credentialId = null;
        String orgName = null;
        StringBuilder sb = new StringBuilder();
        if (this.scmConfig != null) {
            apiUrl = this.scmConfig.getUri();
            credentialId = this.scmConfig.getCredentialId();
            if (this.scmConfig.getConfig().get("orgName") instanceof String) {
                orgName = (String)this.scmConfig.getConfig().get("orgName");
            }
        }
        for (SCMNavigator navigator : folder.getNavigators()) {
            if (!(navigator instanceof GitHubSCMNavigator)) continue;
            GitHubSCMNavigator scmNavigator = (GitHubSCMNavigator)navigator;
            if (scmNavigator.getApiUri() != null && !scmNavigator.getApiUri().equals(apiUrl)) {
                apiUrl = scmNavigator.getApiUri();
            }
            if (scmNavigator.getScanCredentialsId() != null && !scmNavigator.getScanCredentialsId().equals(credentialId)) {
                credentialId = scmNavigator.getScanCredentialsId();
            }
            if (!scmNavigator.getRepoOwner().equals(orgName)) {
                orgName = scmNavigator.getRepoOwner();
            }
            GitHubSCMNavigator gitHubSCMNavigator = new GitHubSCMNavigator(apiUrl, orgName, credentialId, credentialId);
            GithubPipelineCreateRequest.validateCredentialId(credentialId, folder, gitHubSCMNavigator);
            if (this.scmConfig != null && this.scmConfig.getConfig().get("repos") instanceof List) {
                for (String r : (List)this.scmConfig.getConfig().get("repos")) {
                    sb.append(String.format("(%s\\b)?", r));
                }
            }
            if (sb.length() > 0) {
                gitHubSCMNavigator.setPattern(sb.toString());
            }
            return gitHubSCMNavigator;
        }
        return null;
    }
}

