/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.geom;

import io.jenetics.jpx.Length;
import io.jenetics.jpx.Point;
import io.jenetics.jpx.geom.DoubleAdder;
import io.jenetics.jpx.geom.Geoid;
import java.util.Objects;

final class LengthCollector {
    private final Geoid _geoid;
    private final DoubleAdder _length = new DoubleAdder();
    private Point _first;
    private Point _start;

    LengthCollector(Geoid geoid) {
        this._geoid = Objects.requireNonNull(geoid);
    }

    LengthCollector combine(LengthCollector other) {
        throw new UnsupportedOperationException();
    }

    void add(Point point) {
        Objects.requireNonNull(point);
        if (this._first == null) {
            this._first = point;
        }
        Point end = this._start;
        this._start = point;
        if (end != null) {
            this._length.add(this._geoid.distance(end, this._start).doubleValue());
        }
    }

    Length pathLength() {
        return Length.of(this._length.doubleValue(), Length.Unit.METER);
    }

    Length tourLength() {
        if (this._start != null && this._first != null) {
            this._length.add(this._geoid.distance(this._start, this._first).doubleValue());
        }
        return this.pathLength();
    }
}

