/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.format.CompositeFormat;
import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.ParseException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class OptionalFormat
implements Format {
    private final Format _format;

    private OptionalFormat(Format format) {
        this._format = Objects.requireNonNull(format);
    }

    @Override
    public Optional<String> format(Location value) {
        return Optional.of(this._format.format(value).orElse(""));
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        int index = pos.getIndex();
        int errorIndex = pos.getErrorIndex();
        LocationBuilder before = builder.copy();
        try {
            this._format.parse(in, pos, builder);
        }
        catch (ParseException e) {
            builder.copy(before);
            pos.setIndex(index);
            pos.setErrorIndex(errorIndex);
        }
    }

    @Override
    public String toPattern() {
        return String.format("[%s]", this._format.toPattern());
    }

    static OptionalFormat of(List<Format> formats) {
        return new OptionalFormat(CompositeFormat.of(formats));
    }
}

