/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.ParseException;
import java.text.ParsePosition;
import java.util.Optional;

enum LongitudeEW implements Format
{
    INSTANCE;


    @Override
    public Optional<String> format(Location value) {
        return value.longitude().map(Longitude::toDegrees).map(v -> Double.compare(v, 0.0) >= 0 ? "E" : "W");
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        int i = pos.getIndex();
        switch (in.charAt(i)) {
            case 'E': {
                pos.setIndex(i + 1);
                builder.setLongitudeSign(1);
                break;
            }
            case 'W': {
                pos.setIndex(i + 1);
                builder.setLongitudeSign(-1);
                break;
            }
            default: {
                pos.setErrorIndex(i);
                throw new ParseException("Not found E/W", in, i);
            }
        }
    }

    @Override
    public String toPattern() {
        return "x";
    }
}

