/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.Point;
import io.jenetics.jpx.WayPoint;
import java.util.Objects;
import java.util.Optional;

public final class Location {
    private final Latitude _latitude;
    private final Longitude _longitude;
    private final Length _elevation;

    private Location(Latitude latitude, Longitude longitude, Length elevation) {
        this._latitude = latitude;
        this._longitude = longitude;
        this._elevation = elevation;
    }

    public Optional<Latitude> latitude() {
        return Optional.ofNullable(this._latitude);
    }

    public Optional<Longitude> longitude() {
        return Optional.ofNullable(this._longitude);
    }

    public Optional<Length> elevation() {
        return Optional.ofNullable(this._elevation);
    }

    public Optional<Point> toPoint() {
        return this.latitude().flatMap(lat -> this.longitude().map(lon -> WayPoint.of(lat, lon, this._elevation, null)));
    }

    public int hashCode() {
        return Objects.hash(this._latitude, this._longitude, this._elevation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof Location)) return false;
        Location loc = (Location)other;
        if (!Objects.equals(this._latitude, loc._latitude)) return false;
        if (!Objects.equals(this._longitude, loc._longitude)) return false;
        if (!Objects.equals(this._elevation, loc._elevation)) return false;
        return true;
    }

    public String toString() {
        return String.format("[lat=%s, lon=%s, ele=%s]", this._latitude, this._longitude, this._elevation);
    }

    public static Location of(Point point) {
        Objects.requireNonNull(point);
        return Location.of(point.getLatitude(), point.getLongitude(), point.getElevation().orElse(null));
    }

    public static Location of(Latitude latitude, Longitude longitude, Length elevation) {
        return new Location(latitude, longitude, elevation);
    }

    public static Location of(Latitude latitude, Longitude longitude) {
        return new Location(latitude, longitude, null);
    }

    public static Location of(Latitude latitude) {
        return new Location(latitude, null, null);
    }

    public static Location of(Longitude longitude) {
        return new Location(null, longitude, null);
    }

    public static Location of(Length elevation) {
        return new Location(null, null, elevation);
    }
}

