/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.LocationFormatter;
import io.jenetics.jpx.format.ParseException;
import java.text.ParsePosition;
import java.util.Objects;
import java.util.Optional;

final class ConstFormat
implements Format {
    private final String _value;

    private ConstFormat(String value) {
        this._value = Objects.requireNonNull(value);
    }

    @Override
    public Optional<String> format(Location value) {
        return Optional.of(this._value);
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        int start = pos.getIndex();
        int end = start + this._value.length();
        if (end <= in.length()) {
            String s = in.subSequence(start, end).toString();
            if (s.equals(this._value)) {
                pos.setIndex(end);
            } else {
                pos.setErrorIndex(start);
                throw new ParseException(String.format("Not found constant '%s'", this._value), in, start);
            }
        }
    }

    @Override
    public String toPattern() {
        return ConstFormat.escape(this._value);
    }

    private static String escape(String value) {
        StringBuilder out = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (LocationFormatter.PROTECTED_CHARS.contains(Character.valueOf(c))) {
                quoted = true;
            }
            if (c == '\'') {
                out.append(c);
            }
            out.append(c);
        }
        return quoted ? "'" + out + "'" : out.toString();
    }

    static ConstFormat of(String value) {
        return new ConstFormat(value);
    }
}

