/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLStreamWriterAdapter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@FunctionalInterface
interface XMLWriter<T> {
    public void write(XMLStreamWriter var1, T var2) throws XMLStreamException;

    default public <B> XMLWriter<B> map(Function<? super B, ? extends T> mapper) {
        return (xml, data) -> {
            Object value;
            if (data != null && (value = mapper.apply((Object)data)) != null && value != Optional.empty()) {
                this.write(xml, value);
            }
        };
    }

    default public <B> XMLWriter<B> flatMap(Function<? super B, ? extends Optional<? extends T>> mapper) {
        return (xml, data) -> {
            Optional value;
            if (data != null && (value = (Optional)mapper.apply((Object)data)).isPresent()) {
                this.write(xml, value.orElseThrow());
            }
        };
    }

    public static <T> XMLWriter<T> attr(String name) {
        Objects.requireNonNull(name);
        return (xml, data) -> {
            if (data != null) {
                xml.writeAttribute(name, data.toString());
            }
        };
    }

    public static <T> XMLWriter<T> ns(String namespace) {
        return (xml, data) -> xml.writeDefaultNamespace(namespace);
    }

    @SafeVarargs
    public static <T> XMLWriter<T> elem(String name, XMLWriter<? super T> ... children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(children);
        return (xml, data) -> {
            if (data != null && children.length > 0) {
                xml.writeStartElement(name);
                for (XMLWriter child : children) {
                    child.write(xml, data);
                }
                xml.writeEndElement();
            }
        };
    }

    public static XMLWriter<String> elem(String name) {
        return XMLWriter.elem(name, XMLWriter.text());
    }

    public static <T> XMLWriter<T> text() {
        return (xml, data) -> {
            if (data != null) {
                xml.writeCharacters(data.toString());
            }
        };
    }

    public static <N extends Number> XMLWriter<N> number() {
        return (xml, data) -> {
            if (data != null) {
                xml.writeCharacters(Double.toString(data.doubleValue()));
            }
        };
    }

    public static XMLWriter<Document> doc(String name) {
        Objects.requireNonNull(name);
        return (xml, data) -> {
            if (data != null) {
                Element root = data.getDocumentElement();
                XML.copy((Node)root, new XMLStreamWriterAdapter(xml){

                    @Override
                    public void writeEndDocument() {
                    }

                    @Override
                    public void writeStartDocument() {
                    }

                    @Override
                    public void writeStartDocument(String version) {
                    }

                    @Override
                    public void writeStartDocument(String encoding, String version) {
                    }
                });
            }
        };
    }

    public static <T> XMLWriter<Iterable<T>> elems(XMLWriter<? super T> writer) {
        Objects.requireNonNull(writer);
        return (xml, data) -> {
            if (data != null) {
                for (Object value : data) {
                    if (value == null || value == Optional.empty()) continue;
                    writer.write(xml, (Object)value);
                }
            }
        };
    }
}

