/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.AttrReader;
import io.jenetics.jpx.DocReader;
import io.jenetics.jpx.ElemReader;
import io.jenetics.jpx.IgnoreReader;
import io.jenetics.jpx.ListReader;
import io.jenetics.jpx.TextReader;
import io.jenetics.jpx.XMLStreamReaderAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;

abstract class XMLReader<T> {
    private final String _name;
    private final Type _type;

    XMLReader(String name, Type type) {
        this._name = Objects.requireNonNull(name);
        this._type = Objects.requireNonNull(type);
    }

    public abstract T read(XMLStreamReaderAdapter var1, boolean var2) throws XMLStreamException;

    public <B> XMLReader<B> map(Function<? super T, ? extends B> mapper) {
        return this.map(mapper, null);
    }

    public <B> XMLReader<B> map(final Function<? super T, ? extends B> mapper, final B devault) {
        Objects.requireNonNull(mapper);
        return new XMLReader<B>(this._name, this._type){

            @Override
            public B read(XMLStreamReaderAdapter xml, boolean lenient) throws XMLStreamException {
                try {
                    return mapper.apply(XMLReader.this.read(xml, lenient));
                }
                catch (RuntimeException e) {
                    if (!lenient) {
                        throw new XMLStreamException(String.format("Invalid value for '%s': %s", XMLReader.this._name, e.getMessage()), e);
                    }
                    return devault;
                }
            }
        };
    }

    String name() {
        return this._name;
    }

    Type type() {
        return this._type;
    }

    public String toString() {
        return String.format("Reader[%s, %s]", new Object[]{this.name(), this.type()});
    }

    public static XMLReader<String> attr(String name) {
        return new AttrReader(name);
    }

    public static XMLReader<String> text() {
        return new TextReader();
    }

    public static <T> XMLReader<T> elem(Function<Object[], T> generator, String name, XMLReader<?> ... children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(generator);
        Stream.of(Objects.requireNonNull(children)).forEach(Objects::requireNonNull);
        return new ElemReader<T>(name, generator, Arrays.asList(children), Type.ELEM);
    }

    public static <T> XMLReader<T> elem(String name, XMLReader<? extends T> reader) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(reader);
        return XMLReader.elem(v -> {
            Object value = ((Object[])v).length > 0 ? v[0] : null;
            return value;
        }, name, reader);
    }

    public static XMLReader<String> elem(String name) {
        return XMLReader.elem(name, XMLReader.text());
    }

    public static XMLReader<Object> ignore(String name) {
        return new IgnoreReader(name);
    }

    public static <T> XMLReader<List<T>> elems(XMLReader<? extends T> reader) {
        return new ListReader<T>(reader);
    }

    public static XMLReader<Document> doc(String name) {
        return new DocReader(name);
    }

    static enum Type {
        ELEM,
        ATTR,
        LIST,
        TEXT;

    }
}

