/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.XMLProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XML {
    private XML() {
    }

    private static void __copy(Source source, Result sink) throws XMLStreamException {
        try {
            Transformer transformer = TFHolder.INSTANCE.factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("version", "1.0");
            transformer.transform(source, sink);
        }
        catch (TransformerException e) {
            throw new XMLStreamException(e);
        }
    }

    static void copy(XMLStreamReader source, Document sink) throws XMLStreamException {
        XML.__copy(new StAXSource(source), new DOMResult(sink));
    }

    static void copy(Node source, XMLStreamWriter sink) throws XMLStreamException {
        XML.__copy(new DOMSource(source), new StAXResult(sink));
    }

    static void copy(Node source, OutputStream sink) throws IOException {
        try {
            XML.__copy(new DOMSource(source), new StreamResult(sink));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    static String toString(Node source) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XML.copy(source, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }

    static DocumentBuilder builder() throws XMLStreamException {
        try {
            return XMLProvider.provider().documentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XMLStreamException(e);
        }
    }

    static Document parse(String xml) {
        try {
            Document doc = XML.builder().newDocument();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            XML.__copy(new StreamSource(in), new DOMResult(doc));
            return XML.clean(doc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Document clone(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            Transformer transformer = TFHolder.INSTANCE.factory.newTransformer();
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            return (Document)result.getNode();
        }
        catch (TransformerException e) {
            throw (DOMException)new DOMException(9, e.getMessage()).initCause(e);
        }
    }

    static boolean equals(Node n1, Node n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (!Objects.equals(n1.getNodeValue(), n2.getNodeValue())) {
            return false;
        }
        if (!XML.equals(n1.getAttributes(), n2.getAttributes())) {
            return false;
        }
        NodeList nl1 = n1.getChildNodes();
        NodeList nl2 = n2.getChildNodes();
        if (nl1.getLength() != nl2.getLength()) {
            return false;
        }
        for (int i = 0; i < nl1.getLength(); ++i) {
            if (XML.equals(nl1.item(i), nl2.item(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(NamedNodeMap a1, NamedNodeMap a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getLength() != a2.getLength()) {
            return false;
        }
        for (int i = 0; i < a1.getLength(); ++i) {
            String v2;
            String v1;
            String name = a1.item(i).getNodeName();
            if ("xmlns".equals(name) || Objects.equals(v1 = a1.item(i).getNodeValue(), v2 = a2.getNamedItem(a1.item(i).getNodeName()).getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(Document doc) {
        return doc == null || doc.getDocumentElement().getChildNodes().getLength() == 0;
    }

    private static <T extends Node> T clean(T node) {
        if (node == null) {
            return null;
        }
        node.normalize();
        ArrayList<Node> remove = new ArrayList<Node>();
        XML.clean(node, remove);
        for (Node n : remove) {
            if (n.getParentNode() == null) continue;
            n.getParentNode().removeChild(n);
        }
        return node;
    }

    private static void clean(Node node, List<Node> remove) {
        if (node.getNodeType() == 3 && XML.isEmpty(node.getTextContent())) {
            remove.add(node);
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            XML.clean(list.item(i), remove);
        }
    }

    private static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        if (text.isEmpty()) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static Document removeNS(Document doc) {
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        Element newRoot = doc.createElement(root.getNodeName());
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            newRoot.appendChild(children.item(i).cloneNode(true));
        }
        doc.replaceChild(newRoot, root);
        return doc;
    }

    static Document extensions(Document extensions) {
        Document doc = XML.clean(extensions);
        return XML.isEmpty(doc) ? null : doc;
    }

    static Document checkExtensions(Document extensions) {
        if (extensions != null) {
            String ns;
            Element root = extensions.getDocumentElement();
            if (root == null) {
                throw new IllegalArgumentException("'extensions' has no document element.");
            }
            if (!"extensions".equals(root.getNodeName())) {
                throw new IllegalArgumentException(String.format("Expected 'extensions' root element, but got '%s'.", root.getNodeName()));
            }
            if (!(root.getNamespaceURI() == null || (ns = root.getNamespaceURI()).isEmpty() || ns.startsWith("http://www.topografix.com/GPX/1/1") || ns.startsWith("http://www.topografix.com/GPX/1/0"))) {
                throw new IllegalArgumentException(String.format("Invalid document namespace: '%s'.", ns));
            }
        }
        return extensions;
    }

    private static final class TFHolder {
        private static final TFHolder INSTANCE = new TFHolder();
        final TransformerFactory factory = TransformerFactory.newInstance();

        private TFHolder() {
        }
    }
}

