/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.DGPSStation;
import io.jenetics.jpx.Degrees;
import io.jenetics.jpx.Fix;
import io.jenetics.jpx.Format;
import io.jenetics.jpx.GPX;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Instants;
import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.Point;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Speed;
import io.jenetics.jpx.TimeFormat;
import io.jenetics.jpx.UInt;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLReaders;
import io.jenetics.jpx.XMLWriter;
import io.jenetics.jpx.XMLWriters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.w3c.dom.Document;

public final class WayPoint
implements Point,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Latitude _latitude;
    private final Longitude _longitude;
    private final Length _elevation;
    private final Speed _speed;
    private final Instant _time;
    private final Degrees _magneticVariation;
    private final Length _geoidHeight;
    private final String _name;
    private final String _comment;
    private final String _description;
    private final String _source;
    private final List<Link> _links;
    private final String _symbol;
    private final String _type;
    private final Fix _fix;
    private final UInt _sat;
    private final Double _hdop;
    private final Double _vdop;
    private final Double _pdop;
    private final Duration _ageOfGPSData;
    private final DGPSStation _dgpsID;
    private final Degrees _course;
    private final Document _extensions;

    private WayPoint(Latitude latitude, Longitude longitude, Length elevation, Speed speed, Instant time, Degrees magneticVariation, Length geoidHeight, String name, String comment, String description, String source, List<Link> links, String symbol, String type, Fix fix, UInt sat, Double hdop, Double vdop, Double pdop, Duration ageOfGPSData, DGPSStation dgpsID, Degrees course, Document extensions) {
        this._latitude = Objects.requireNonNull(latitude);
        this._longitude = Objects.requireNonNull(longitude);
        this._elevation = elevation;
        this._speed = speed;
        this._time = time;
        this._magneticVariation = magneticVariation;
        this._geoidHeight = geoidHeight;
        this._name = name;
        this._comment = comment;
        this._description = description;
        this._source = source;
        this._links = Lists.copyOf(links);
        this._symbol = symbol;
        this._type = type;
        this._fix = fix;
        this._sat = sat;
        this._hdop = hdop;
        this._vdop = vdop;
        this._pdop = pdop;
        this._ageOfGPSData = ageOfGPSData;
        this._dgpsID = dgpsID;
        this._course = course;
        this._extensions = extensions;
    }

    @Override
    public Latitude getLatitude() {
        return this._latitude;
    }

    @Override
    public Longitude getLongitude() {
        return this._longitude;
    }

    @Override
    public Optional<Length> getElevation() {
        return Optional.ofNullable(this._elevation);
    }

    public Optional<Speed> getSpeed() {
        return Optional.ofNullable(this._speed);
    }

    @Override
    public Optional<Instant> getTime() {
        return Optional.ofNullable(this._time);
    }

    public Optional<Degrees> getMagneticVariation() {
        return Optional.ofNullable(this._magneticVariation);
    }

    public Optional<Length> getGeoidHeight() {
        return Optional.ofNullable(this._geoidHeight);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this._comment);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this._description);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this._source);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public Optional<String> getSymbol() {
        return Optional.ofNullable(this._symbol);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this._type);
    }

    public Optional<Fix> getFix() {
        return Optional.ofNullable(this._fix);
    }

    public Optional<UInt> getSat() {
        return Optional.ofNullable(this._sat);
    }

    public Optional<Double> getHdop() {
        return Optional.ofNullable(this._hdop);
    }

    public Optional<Double> getVdop() {
        return Optional.ofNullable(this._vdop);
    }

    public Optional<Double> getPdop() {
        return Optional.ofNullable(this._pdop);
    }

    public Optional<Duration> getAgeOfGPSData() {
        return Optional.ofNullable(this._ageOfGPSData);
    }

    public Optional<DGPSStation> getDGPSID() {
        return Optional.ofNullable(this._dgpsID);
    }

    public Optional<Degrees> getCourse() {
        return Optional.ofNullable(this._course);
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    public Builder toBuilder() {
        return WayPoint.builder().lat(this._latitude).lon(this._longitude).ele(this._elevation).speed(this._speed).time(this._time).magvar(this._magneticVariation).geoidheight(this._geoidHeight).name(this._name).cmt(this._comment).desc(this._description).src(this._source).links(this._links).sym(this._symbol).type(this._type).fix(this._fix).sat(this._sat).hdop(this._hdop).vdop(this._vdop).pdop(this._pdop).ageofdgpsdata(this._ageOfGPSData).dgpsid(this._dgpsID).course(this._course).extensions(this._extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._latitude, this._longitude, this._elevation, this._speed, Objects.hashCode(this._time), this._magneticVariation, this._geoidHeight, this._name, this._comment, this._description, this._source, Lists.hashCode(this._links), this._symbol, this._type, this._fix, this._sat, this._hdop, this._vdop, this._pdop, this._ageOfGPSData, this._dgpsID, this._course});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof WayPoint)) return false;
        WayPoint wp = (WayPoint)obj;
        if (!Objects.equals(wp._latitude, this._latitude)) return false;
        if (!Objects.equals(wp._longitude, this._longitude)) return false;
        if (!Objects.equals(wp._elevation, this._elevation)) return false;
        if (!Objects.equals(wp._speed, this._speed)) return false;
        if (!Objects.equals(wp._time, this._time)) return false;
        if (!Objects.equals(wp._magneticVariation, this._magneticVariation)) return false;
        if (!Objects.equals(wp._geoidHeight, this._geoidHeight)) return false;
        if (!Objects.equals(wp._name, this._name)) return false;
        if (!Objects.equals(wp._comment, this._comment)) return false;
        if (!Objects.equals(wp._description, this._description)) return false;
        if (!Objects.equals(wp._source, this._source)) return false;
        if (!Lists.equals(wp._links, this._links)) return false;
        if (!Objects.equals(wp._symbol, this._symbol)) return false;
        if (!Objects.equals(wp._type, this._type)) return false;
        if (!Objects.equals((Object)wp._fix, (Object)this._fix)) return false;
        if (!Objects.equals(wp._sat, this._sat)) return false;
        if (!Objects.equals(wp._hdop, this._hdop)) return false;
        if (!Objects.equals(wp._vdop, this._vdop)) return false;
        if (!Objects.equals(wp._pdop, this._pdop)) return false;
        if (!Objects.equals(wp._ageOfGPSData, this._ageOfGPSData)) return false;
        if (!Objects.equals(wp._dgpsID, this._dgpsID)) return false;
        if (!Objects.equals(wp._course, this._course)) return false;
        return true;
    }

    public String toString() {
        return this._elevation != null ? String.format("[lat=%s, lon=%s, ele=%s]", this._latitude, this._longitude, this._elevation) : String.format("[lat=%s, lon=%s]", this._latitude, this._longitude);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WayPoint of(Latitude latitude, Longitude longitude, Length elevation, Speed speed, Instant time, Degrees magneticVariation, Length geoidHeight, String name, String comment, String description, String source, List<Link> links, String symbol, String type, Fix fix, UInt sat, Double hdop, Double vdop, Double pdop, Duration ageOfGPSData, DGPSStation dgpsID, Degrees course, Document extensions) {
        return new WayPoint(latitude, longitude, elevation, speed, time, magneticVariation, geoidHeight, name, comment, description, source, links, symbol, type, fix, sat, hdop, vdop, pdop, ageOfGPSData, dgpsID, course, XML.extensions(XML.clone(extensions)));
    }

    public static WayPoint of(Latitude latitude, Longitude longitude) {
        return new WayPoint(latitude, longitude, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static WayPoint of(double latitudeDegree, double longitudeDegree) {
        return WayPoint.of(Latitude.ofDegrees(latitudeDegree), Longitude.ofDegrees(longitudeDegree));
    }

    public static WayPoint of(Latitude latitude, Longitude longitude, Instant time) {
        return new WayPoint(latitude, longitude, null, null, time, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static WayPoint of(double latitudeDegree, double longitudeDegree, long timeEpochMilli) {
        return WayPoint.of(Latitude.ofDegrees(latitudeDegree), Longitude.ofDegrees(longitudeDegree), Instant.ofEpochMilli(timeEpochMilli));
    }

    public static WayPoint of(Latitude latitude, Longitude longitude, Length elevation, Instant time) {
        return new WayPoint(latitude, longitude, elevation, null, time, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static WayPoint of(double latitudeDegree, double longitudeDegree, double elevationMeter, long timeEpochMilli) {
        return WayPoint.of(Latitude.ofDegrees(latitudeDegree), Longitude.ofDegrees(longitudeDegree), Length.of(elevationMeter, Length.Unit.METER), Instant.ofEpochMilli(timeEpochMilli));
    }

    public static WayPoint of(Latitude latitude, Longitude longitude, Length elevation, Speed speed, Instant time, Degrees magneticVariation, Length geoidHeight, String name, String comment, String description, String source, List<Link> links, String symbol, String type, Fix fix, UInt sat, Double hdop, Double vdop, Double pdop, Duration ageOfGPSData, DGPSStation dgpsID, Degrees course) {
        return new WayPoint(latitude, longitude, elevation, speed, time, magneticVariation, geoidHeight, name, comment, description, source, links, symbol, type, fix, sat, hdop, vdop, pdop, ageOfGPSData, dgpsID, course, null);
    }

    public static WayPoint of(Point point) {
        Objects.requireNonNull(point);
        return point instanceof WayPoint ? (WayPoint)point : WayPoint.of(point.getLatitude(), point.getLongitude(), point.getElevation().orElse(null), point.getTime().orElse(null));
    }

    private Object writeReplace() throws IOException {
        return new SerialProxy(18, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        int existing = 0;
        if (this._elevation != null) {
            existing |= 1;
        }
        if (this._speed != null) {
            existing |= 2;
        }
        if (this._time != null) {
            existing |= 4;
        }
        if (this._magneticVariation != null) {
            existing |= 8;
        }
        if (this._geoidHeight != null) {
            existing |= 0x10;
        }
        if (this._name != null) {
            existing |= 0x20;
        }
        if (this._comment != null) {
            existing |= 0x40;
        }
        if (this._description != null) {
            existing |= 0x80;
        }
        if (this._source != null) {
            existing |= 0x100;
        }
        if (this._links != null && !this._links.isEmpty()) {
            existing |= 0x200;
        }
        if (this._symbol != null) {
            existing |= 0x400;
        }
        if (this._type != null) {
            existing |= 0x800;
        }
        if (this._fix != null) {
            existing |= 0x1000;
        }
        if (this._sat != null) {
            existing |= 0x2000;
        }
        if (this._hdop != null) {
            existing |= 0x4000;
        }
        if (this._vdop != null) {
            existing |= 0x8000;
        }
        if (this._pdop != null) {
            existing |= 0x10000;
        }
        if (this._ageOfGPSData != null) {
            existing |= 0x20000;
        }
        if (this._dgpsID != null) {
            existing |= 0x40000;
        }
        if (this._course != null) {
            existing |= 0x80000;
        }
        if (this._extensions != null) {
            existing |= 0x100000;
        }
        out.writeInt(existing);
        out.writeDouble(this._latitude.toDegrees());
        out.writeDouble(this._longitude.toDegrees());
        if ((existing & 1) != 0) {
            assert (this._elevation != null);
            this._elevation.write(out);
        }
        if ((existing & 2) != 0) {
            assert (this._speed != null);
            this._speed.write(out);
        }
        if ((existing & 4) != 0) {
            assert (this._time != null);
            Instants.write(this._time, out);
        }
        if ((existing & 8) != 0) {
            assert (this._magneticVariation != null);
            this._magneticVariation.write(out);
        }
        if ((existing & 0x10) != 0) {
            assert (this._geoidHeight != null);
            this._geoidHeight.write(out);
        }
        if ((existing & 0x20) != 0) {
            assert (this._name != null);
            IO.writeString(this._name, out);
        }
        if ((existing & 0x40) != 0) {
            assert (this._comment != null);
            IO.writeString(this._comment, out);
        }
        if ((existing & 0x80) != 0) {
            assert (this._description != null);
            IO.writeString(this._description, out);
        }
        if ((existing & 0x100) != 0) {
            assert (this._source != null);
            IO.writeString(this._source, out);
        }
        if ((existing & 0x200) != 0) {
            assert (this._links != null);
            IO.writes(this._links, Link::write, out);
        }
        if ((existing & 0x400) != 0) {
            assert (this._symbol != null);
            IO.writeString(this._symbol, out);
        }
        if ((existing & 0x800) != 0) {
            assert (this._type != null);
            IO.writeString(this._type, out);
        }
        if ((existing & 0x1000) != 0) {
            assert (this._fix != null);
            IO.writeString(this._fix.name(), out);
        }
        if ((existing & 0x2000) != 0) {
            assert (this._sat != null);
            this._sat.write(out);
        }
        if ((existing & 0x4000) != 0) {
            assert (this._hdop != null);
            out.writeDouble(this._hdop);
        }
        if ((existing & 0x8000) != 0) {
            assert (this._vdop != null);
            out.writeDouble(this._vdop);
        }
        if ((existing & 0x10000) != 0) {
            assert (this._pdop != null);
            out.writeDouble(this._pdop);
        }
        if ((existing & 0x20000) != 0) {
            assert (this._ageOfGPSData != null);
            out.writeLong(this._ageOfGPSData.toMillis());
        }
        if ((existing & 0x40000) != 0) {
            assert (this._dgpsID != null);
            this._dgpsID.write(out);
        }
        if ((existing & 0x80000) != 0) {
            assert (this._course != null);
            this._course.write(out);
        }
        if ((existing & 0x100000) != 0) {
            assert (this._extensions != null);
            IO.write(this._extensions, out);
        }
    }

    static WayPoint read(DataInput in) throws IOException {
        int existing = in.readInt();
        return new WayPoint(Latitude.ofDegrees(in.readDouble()), Longitude.ofDegrees(in.readDouble()), (existing & 1) != 0 ? Length.read(in) : null, (existing & 2) != 0 ? Speed.read(in) : null, (existing & 4) != 0 ? Instants.read(in) : null, (existing & 8) != 0 ? Degrees.read(in) : null, (existing & 0x10) != 0 ? Length.read(in) : null, (existing & 0x20) != 0 ? IO.readString(in) : null, (existing & 0x40) != 0 ? IO.readString(in) : null, (existing & 0x80) != 0 ? IO.readString(in) : null, (existing & 0x100) != 0 ? IO.readString(in) : null, (existing & 0x200) != 0 ? IO.reads(Link::read, in) : null, (existing & 0x400) != 0 ? IO.readString(in) : null, (existing & 0x800) != 0 ? IO.readString(in) : null, (existing & 0x1000) != 0 ? Fix.valueOf(IO.readString(in)) : null, (existing & 0x2000) != 0 ? UInt.read(in) : null, (existing & 0x4000) != 0 ? Double.valueOf(in.readDouble()) : null, (existing & 0x8000) != 0 ? Double.valueOf(in.readDouble()) : null, (existing & 0x10000) != 0 ? Double.valueOf(in.readDouble()) : null, (existing & 0x20000) != 0 ? Duration.ofMillis(in.readLong()) : null, (existing & 0x40000) != 0 ? DGPSStation.read(in) : null, (existing & 0x80000) != 0 ? Degrees.read(in) : null, (existing & 0x100000) != 0 ? IO.readDoc(in) : null);
    }

    private static String url(WayPoint point) {
        return point.getLinks().isEmpty() ? null : point.getLinks().get(0).getHref().toString();
    }

    private static String urlname(WayPoint point) {
        return point.getLinks().isEmpty() ? null : (String)point.getLinks().get(0).getText().orElse(null);
    }

    private static XMLWriters<WayPoint> writers(Function<? super Number, String> formatter) {
        return new XMLWriters<WayPoint>().v00(XMLWriter.attr("lat").map(wp -> formatter.apply(wp._latitude))).v00(XMLWriter.attr("lon").map(wp -> formatter.apply(wp._longitude))).v00(XMLWriter.elem("ele").map(wp -> (String)formatter.apply(wp._elevation))).v00(XMLWriter.elem("speed").map(wp -> (String)formatter.apply(wp._speed))).v00(XMLWriter.elem("time").map(wp -> TimeFormat.format(wp._time))).v00(XMLWriter.elem("magvar").map(wp -> (String)formatter.apply(wp._magneticVariation))).v00(XMLWriter.elem("geoidheight").map(wp -> (String)formatter.apply(wp._geoidHeight))).v00(XMLWriter.elem("name").map(wp -> wp._name)).v00(XMLWriter.elem("cmt").map(wp -> wp._comment)).v00(XMLWriter.elem("desc").map(wp -> wp._description)).v00(XMLWriter.elem("src").map(wp -> wp._source)).v11(XMLWriter.elems(Link.WRITER).map(wp -> wp._links)).v10(XMLWriter.elem("url").map(WayPoint::url)).v10(XMLWriter.elem("urlname").map(WayPoint::urlname)).v00(XMLWriter.elem("sym").map(wp -> wp._symbol)).v00(XMLWriter.elem("type").map(wp -> wp._type)).v00(XMLWriter.elem("fix").map(wp -> Fix.format(wp._fix))).v00(XMLWriter.elem("sat").map(wp -> Format.toIntString(wp._sat))).v00(XMLWriter.elem("hdop").map(wp -> (String)formatter.apply(wp._hdop))).v00(XMLWriter.elem("vdop").map(wp -> (String)formatter.apply(wp._vdop))).v00(XMLWriter.elem("pdop").map(wp -> (String)formatter.apply(wp._pdop))).v00(XMLWriter.elem("ageofdgpsdata").map(wp -> Format.toDurationString(wp._ageOfGPSData))).v00(XMLWriter.elem("dgpsid").map(wp -> Format.toIntString(wp._dgpsID))).v10(XMLWriter.elem("course").map(wp -> (String)formatter.apply(wp._course))).v00(XMLWriter.doc("extensions").map(gpx -> gpx._extensions));
    }

    private static XMLReaders readers(Function<? super String, Length> lengthParser) {
        return new XMLReaders().v00(XMLReader.attr("lat").map(Latitude::parse)).v00(XMLReader.attr("lon").map(Longitude::parse)).v00(XMLReader.elem("ele").map(lengthParser)).v00(XMLReader.elem("speed").map(Speed::parse)).v00(XMLReader.elem("time").map(TimeFormat::parse)).v00(XMLReader.elem("magvar").map(Degrees::parse)).v00(XMLReader.elem("geoidheight").map(lengthParser)).v00(XMLReader.elem("name")).v00(XMLReader.elem("cmt")).v00(XMLReader.elem("desc")).v00(XMLReader.elem("src")).v11(XMLReader.elems(Link.READER)).v10(XMLReader.elem("url").map(Format::parseURI)).v10(XMLReader.elem("urlname")).v00(XMLReader.elem("sym")).v00(XMLReader.elem("type")).v00(XMLReader.elem("fix").map(Fix::parse)).v00(XMLReader.elem("sat").map(UInt::parse)).v00(XMLReader.elem("hdop").map(Format::parseDouble)).v00(XMLReader.elem("vdop").map(Format::parseDouble)).v00(XMLReader.elem("pdop").map(Format::parseDouble)).v00(XMLReader.elem("ageofdgpsdata").map(Format::parseDuration)).v00(XMLReader.elem("dgpsid").map(DGPSStation::parse)).v10(XMLReader.elem("course").map(Degrees::parse)).v00(XMLReader.doc("extensions"));
    }

    static XMLWriter<WayPoint> xmlWriter(GPX.Version version, String name, Function<? super Number, String> formatter) {
        return XMLWriter.elem(name, WayPoint.writers(formatter).writers(version));
    }

    static XMLReader<WayPoint> xmlReader(GPX.Version version, String name, Function<? super String, Length> lengthParser) {
        return XMLReader.elem(version == GPX.Version.V10 ? WayPoint::toWayPointV10 : WayPoint::toWayPointV11, name, WayPoint.readers(lengthParser).readers(version));
    }

    private static WayPoint toWayPointV11(Object[] v) {
        return new WayPoint((Latitude)v[0], (Longitude)v[1], (Length)v[2], (Speed)v[3], (Instant)v[4], (Degrees)v[5], (Length)v[6], (String)v[7], (String)v[8], (String)v[9], (String)v[10], (List)v[11], (String)v[12], (String)v[13], (Fix)((Object)v[14]), (UInt)v[15], (Double)v[16], (Double)v[17], (Double)v[18], (Duration)v[19], (DGPSStation)v[20], null, XML.extensions((Document)v[21]));
    }

    private static WayPoint toWayPointV10(Object[] v) {
        return new WayPoint((Latitude)v[0], (Longitude)v[1], (Length)v[2], (Speed)v[3], (Instant)v[4], (Degrees)v[5], (Length)v[6], (String)v[7], (String)v[8], (String)v[9], (String)v[10], v[11] != null ? List.of(Link.of((URI)v[11], (String)v[12], null)) : null, (String)v[13], (String)v[14], (Fix)((Object)v[15]), (UInt)v[16], (Double)v[17], (Double)v[18], (Double)v[19], (Duration)v[20], (DGPSStation)v[21], (Degrees)v[22], XML.extensions((Document)v[23]));
    }

    public static final class Builder {
        private Latitude _latitude;
        private Longitude _longitude;
        private Length _elevation;
        private Speed _speed;
        private Instant _time;
        private Degrees _magneticVariation;
        private Length _geoidHeight;
        private String _name;
        private String _comment;
        private String _description;
        private String _source;
        private final List<Link> _links = new ArrayList<Link>();
        private String _symbol;
        private String _type;
        private Fix _fix;
        private UInt _sat;
        private Double _hdop;
        private Double _vdop;
        private Double _pdop;
        private Duration _ageOfDGPSData;
        private DGPSStation _dgpsID;
        private Degrees _course;
        private Document _extensions;

        private Builder() {
        }

        public Builder lat(Latitude latitude) {
            this._latitude = Objects.requireNonNull(latitude);
            return this;
        }

        public Builder lat(double degrees) {
            return this.lat(Latitude.ofDegrees(degrees));
        }

        public Latitude lat() {
            return this._latitude;
        }

        public Builder lon(Longitude longitude) {
            this._longitude = Objects.requireNonNull(longitude);
            return this;
        }

        public Builder lon(double degrees) {
            return this.lon(Longitude.ofDegrees(degrees));
        }

        public Longitude lon() {
            return this._longitude;
        }

        public Builder ele(Length elevation) {
            this._elevation = elevation;
            return this;
        }

        public Builder ele(double meters) {
            this._elevation = Length.of(meters, Length.Unit.METER);
            return this;
        }

        public Builder ele(double elevation, Length.Unit unit) {
            this._elevation = Length.of(elevation, unit);
            return this;
        }

        public Optional<Length> ele() {
            return Optional.ofNullable(this._elevation);
        }

        public Builder speed(Speed speed) {
            this._speed = speed;
            return this;
        }

        public Builder speed(double speed, Speed.Unit unit) {
            return this.speed(Speed.of(speed, unit));
        }

        public Builder speed(double meterPerSecond) {
            this._speed = Speed.of(meterPerSecond, Speed.Unit.METERS_PER_SECOND);
            return this;
        }

        public Optional<Speed> speed() {
            return Optional.ofNullable(this._speed);
        }

        public Builder time(Instant instant) {
            this._time = instant;
            return this;
        }

        public Builder time(long millis) {
            this._time = Instant.ofEpochMilli(millis);
            return this;
        }

        public Optional<Instant> time() {
            return Optional.ofNullable(this._time);
        }

        public Builder magvar(Degrees variation) {
            this._magneticVariation = variation;
            return this;
        }

        public Builder magvar(double degree) {
            this._magneticVariation = Degrees.ofDegrees(degree);
            return this;
        }

        public Optional<Degrees> magvar() {
            return Optional.ofNullable(this._magneticVariation);
        }

        public Builder geoidheight(Length height) {
            this._geoidHeight = height;
            return this;
        }

        public Builder geoidheight(double meter) {
            this._geoidHeight = Length.of(meter, Length.Unit.METER);
            return this;
        }

        public Builder geoidheight(double length, Length.Unit unit) {
            this._geoidHeight = Length.of(length, unit);
            return this;
        }

        public Optional<Length> geoidheight() {
            return Optional.ofNullable(this._geoidHeight);
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this._name);
        }

        public Builder cmt(String comment) {
            this._comment = comment;
            return this;
        }

        public Optional<String> cmt() {
            return Optional.ofNullable(this._comment);
        }

        public Builder desc(String description) {
            this._description = description;
            return this;
        }

        public Optional<String> desc() {
            return Optional.ofNullable(this._description);
        }

        public Builder src(String source) {
            this._source = source;
            return this;
        }

        public Optional<String> src() {
            return Optional.ofNullable(this._source);
        }

        public Builder links(List<Link> links) {
            Lists.copyTo(links, this._links);
            return this;
        }

        public Builder addLink(Link link) {
            if (link != null) {
                this._links.add(link);
            }
            return this;
        }

        public Builder addLink(String href) {
            if (href != null) {
                this._links.add(Link.of(href));
            }
            return this;
        }

        public List<Link> links() {
            return new NonNullList<Link>(this._links);
        }

        public Builder sym(String symbol) {
            this._symbol = symbol;
            return this;
        }

        public Optional<String> sym() {
            return Optional.ofNullable(this._symbol);
        }

        public Builder type(String type) {
            this._type = type;
            return this;
        }

        public Optional<String> type() {
            return Optional.ofNullable(this._type);
        }

        public Builder fix(Fix fix) {
            this._fix = fix;
            return this;
        }

        public Builder fix(String fix) {
            this._fix = Fix.parse(fix);
            return this;
        }

        public Optional<Fix> fix() {
            return Optional.ofNullable(this._fix);
        }

        public Builder sat(UInt sat) {
            this._sat = sat;
            return this;
        }

        public Builder sat(int sat) {
            this._sat = UInt.of(sat);
            return this;
        }

        public Optional<UInt> sat() {
            return Optional.ofNullable(this._sat);
        }

        public Builder hdop(Double hdop) {
            this._hdop = hdop;
            return this;
        }

        public Optional<Double> hdop() {
            return Optional.ofNullable(this._hdop);
        }

        public Builder vdop(Double vdop) {
            this._vdop = vdop;
            return this;
        }

        public Optional<Double> vdop() {
            return Optional.ofNullable(this._vdop);
        }

        public Builder pdop(Double pdop) {
            this._pdop = pdop;
            return this;
        }

        public Optional<Double> pdop() {
            return Optional.ofNullable(this._pdop);
        }

        public Builder ageofdgpsdata(Duration age) {
            this._ageOfDGPSData = age;
            return this;
        }

        public Builder ageofdgpsdata(double seconds) {
            this._ageOfDGPSData = Duration.ofMillis((long)(seconds * 1000.0));
            return this;
        }

        public Optional<Duration> ageofdgpsdata() {
            return Optional.ofNullable(this._ageOfDGPSData);
        }

        public Builder dgpsid(DGPSStation station) {
            this._dgpsID = station;
            return this;
        }

        public Builder dgpsid(int station) {
            this._dgpsID = DGPSStation.of(station);
            return this;
        }

        public Optional<DGPSStation> dgpsid() {
            return Optional.ofNullable(this._dgpsID);
        }

        public Builder course(Degrees course) {
            this._course = course;
            return this;
        }

        public Builder course(double courseDegrees) {
            this._course = Degrees.ofDegrees(courseDegrees);
            return this;
        }

        public Optional<Degrees> course() {
            return Optional.ofNullable(this._course);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public WayPoint build(Latitude latitude, Longitude longitude) {
            this.lat(latitude);
            this.lon(longitude);
            return this.build();
        }

        public WayPoint build(double latitude, double longitude) {
            return this.build(Latitude.ofDegrees(latitude), Longitude.ofDegrees(longitude));
        }

        public WayPoint build() {
            if (this._latitude == null || this._longitude == null) {
                throw new IllegalStateException("Latitude and longitude value must be set for creating a new 'WayPoint'.");
            }
            return new WayPoint(this._latitude, this._longitude, this._elevation, this._speed, this._time, this._magneticVariation, this._geoidHeight, this._name, this._comment, this._description, this._source, this._links, this._symbol, this._type, this._fix, this._sat, this._hdop, this._vdop, this._pdop, this._ageOfDGPSData, this._dgpsID, this._course, this._extensions);
        }
    }
}

