/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.IO;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class UInt
extends Number
implements Comparable<UInt>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final int _value;

    private UInt(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("%d is negative.", value));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public int compareTo(UInt other) {
        return Integer.compare(this._value, other._value);
    }

    public int hashCode() {
        return Integer.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof UInt)) return false;
        UInt uint = (UInt)obj;
        if (uint._value != this._value) return false;
        return true;
    }

    public String toString() {
        return Integer.toString(this._value);
    }

    public static UInt of(int value) {
        return new UInt(value);
    }

    static UInt parse(String value) {
        String uint = Strings.trim(value);
        return uint != null ? UInt.of(Integer.parseInt(uint)) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(17, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeInt(this._value, out);
    }

    static UInt read(DataInput in) throws IOException {
        return new UInt(IO.readInt(in));
    }
}

