/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Strings;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

enum TimeFormat {
    ISO_DATE_TIME_UTC(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().toFormatter().withResolverStyle(ResolverStyle.LENIENT).withZone(ZoneOffset.UTC), "^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})*+Z*+$"),
    ISO_DATE_TIME_OFFSET(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().toFormatter(), "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})*+([+-]\\d{2}:\\d{2})");

    private static final DateTimeFormatter FORMATTER;
    private final DateTimeFormatter _formatter;
    private final Pattern[] _patterns;

    private TimeFormat(DateTimeFormatter formatter, String ... patterns) {
        this._formatter = Objects.requireNonNull(formatter);
        this._patterns = (Pattern[])Stream.of(patterns).map(Pattern::compile).toArray(Pattern[]::new);
    }

    private boolean matches(String time) {
        for (Pattern pattern : this._patterns) {
            if (!pattern.matcher(time).matches()) continue;
            return true;
        }
        return false;
    }

    public Instant formatParse(String time) {
        return time != null ? ZonedDateTime.parse(time, this._formatter).toInstant() : null;
    }

    public static String format(Instant time) {
        return time != null ? FORMATTER.format(time) : null;
    }

    static Optional<Instant> parseOptional(String time) {
        TimeFormat format = TimeFormat.findFormat(time);
        if (format != null) {
            return Optional.of(format.formatParse(time));
        }
        return Optional.empty();
    }

    static TimeFormat findFormat(String time) {
        if (ISO_DATE_TIME_UTC.matches(time)) {
            return ISO_DATE_TIME_UTC;
        }
        if (ISO_DATE_TIME_OFFSET.matches(time)) {
            return ISO_DATE_TIME_OFFSET;
        }
        return null;
    }

    static Instant parse(String value) {
        String time = Strings.trim(value);
        if (time != null) {
            TimeFormat format = TimeFormat.findFormat(time);
            if (format != null) {
                return format.formatParse(time);
            }
            throw new IllegalArgumentException(String.format("Can't parse time: '%s'", time));
        }
        return null;
    }

    static {
        FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);
    }
}

