/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Filter;
import io.jenetics.jpx.Format;
import io.jenetics.jpx.GPX;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.UInt;
import io.jenetics.jpx.WayPoint;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLReaders;
import io.jenetics.jpx.XMLWriter;
import io.jenetics.jpx.XMLWriters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.w3c.dom.Document;

public final class Route
implements Iterable<WayPoint>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String _name;
    private final String _comment;
    private final String _description;
    private final String _source;
    private final List<Link> _links;
    private final UInt _number;
    private final String _type;
    private final Document _extensions;
    private final List<WayPoint> _points;

    private Route(String name, String comment, String description, String source, List<Link> links, UInt number, String type, Document extensions, List<WayPoint> points) {
        this._name = name;
        this._comment = comment;
        this._description = description;
        this._source = source;
        this._links = Lists.copyOf(links);
        this._number = number;
        this._type = type;
        this._extensions = extensions;
        this._points = Lists.copyOf(points);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this._comment);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this._description);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this._source);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public Optional<UInt> getNumber() {
        return Optional.ofNullable(this._number);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this._type);
    }

    public List<WayPoint> getPoints() {
        return this._points;
    }

    public Stream<WayPoint> points() {
        return this._points.stream();
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    @Override
    public Iterator<WayPoint> iterator() {
        return this._points.iterator();
    }

    public Builder toBuilder() {
        return Route.builder().name(this._name).cmt(this._comment).desc(this._description).src(this._source).links(this._links).number(this._number).extensions(this._extensions).points(this._points);
    }

    public boolean isEmpty() {
        return this._name == null && this._comment == null && this._description == null && this._source == null && this._links.isEmpty() && this._number == null && this._extensions == null && this._points.isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this._name, this._comment, this._description, this._source, this._type, Lists.hashCode(this._links), this._number, this._points);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Route)) return false;
        Route route = (Route)obj;
        if (!Objects.equals(route._name, this._name)) return false;
        if (!Objects.equals(route._comment, this._comment)) return false;
        if (!Objects.equals(route._description, this._description)) return false;
        if (!Objects.equals(route._source, this._source)) return false;
        if (!Objects.equals(route._type, this._type)) return false;
        if (!Lists.equals(route._links, this._links)) return false;
        if (!Objects.equals(route._number, this._number)) return false;
        if (!Objects.equals(route._points, this._points)) return false;
        return true;
    }

    public String toString() {
        return String.format("Route[name=%s, points=%s]", this._name, this._points.size());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Route of(String name, String comment, String description, String source, List<Link> links, UInt number, String type, Document extensions, List<WayPoint> points) {
        return new Route(name, comment, description, source, links, number, type, XML.extensions(XML.clone(extensions)), points);
    }

    public static Route of(String name, String comment, String description, String source, List<Link> links, UInt number, String type, List<WayPoint> points) {
        return Route.of(name, comment, description, source, links, number, type, null, points);
    }

    public static Route of(String name, List<WayPoint> points) {
        return Route.of(name, null, null, null, null, null, null, null, points);
    }

    public static Route of(List<WayPoint> points) {
        return Route.of(null, null, null, null, null, null, null, null, points);
    }

    private Object writeReplace() {
        return new SerialProxy(13, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeNullableString(this._name, out);
        IO.writeNullableString(this._comment, out);
        IO.writeNullableString(this._description, out);
        IO.writeNullableString(this._source, out);
        IO.writes(this._links, Link::write, out);
        IO.writeNullable(this._number, UInt::write, out);
        IO.writeNullableString(this._type, out);
        IO.writeNullable(this._extensions, IO::write, out);
        IO.writes(this._points, WayPoint::write, out);
    }

    static Route read(DataInput in) throws IOException {
        return new Route(IO.readNullableString(in), IO.readNullableString(in), IO.readNullableString(in), IO.readNullableString(in), IO.reads(Link::read, in), IO.readNullable(UInt::read, in), IO.readNullableString(in), IO.readNullable(IO::readDoc, in), IO.reads(WayPoint::read, in));
    }

    private static String url(Route route) {
        return route.getLinks().isEmpty() ? null : route.getLinks().get(0).getHref().toString();
    }

    private static String urlname(Route route) {
        return route.getLinks().isEmpty() ? null : (String)route.getLinks().get(0).getText().orElse(null);
    }

    private static XMLWriters<Route> writers(Function<? super Number, String> formatter) {
        return new XMLWriters<Route>().v00(XMLWriter.elem("name").map(r -> r._name)).v00(XMLWriter.elem("cmt").map(r -> r._comment)).v00(XMLWriter.elem("desc").map(r -> r._description)).v00(XMLWriter.elem("src").map(r -> r._source)).v11(XMLWriter.elems(Link.WRITER).map(r -> r._links)).v10(XMLWriter.elem("url").map(Route::url)).v10(XMLWriter.elem("urlname").map(Route::urlname)).v00(XMLWriter.elem("number").map(r -> Format.toIntString(r._number))).v00(XMLWriter.elem("type").map(r -> r._type)).v00(XMLWriter.doc("extensions").map(gpx -> gpx._extensions)).v10(XMLWriter.elems(WayPoint.xmlWriter(GPX.Version.V10, "rtept", formatter)).map(r -> r._points)).v11(XMLWriter.elems(WayPoint.xmlWriter(GPX.Version.V11, "rtept", formatter)).map(r -> r._points));
    }

    private static XMLReaders readers(Function<? super String, Length> lengthParser) {
        return new XMLReaders().v00(XMLReader.elem("name")).v00(XMLReader.elem("cmt")).v00(XMLReader.elem("desc")).v00(XMLReader.elem("src")).v11(XMLReader.elems(Link.READER)).v10(XMLReader.elem("url").map(Format::parseURI)).v10(XMLReader.elem("urlname")).v00(XMLReader.elem("number").map(UInt::parse)).v00(XMLReader.elem("type")).v00(XMLReader.doc("extensions")).v10(XMLReader.elems(WayPoint.xmlReader(GPX.Version.V10, "rtept", lengthParser))).v11(XMLReader.elems(WayPoint.xmlReader(GPX.Version.V11, "rtept", lengthParser)));
    }

    static XMLWriter<Route> xmlWriter(GPX.Version version, Function<? super Number, String> formatter) {
        return XMLWriter.elem("rte", Route.writers(formatter).writers(version));
    }

    static XMLReader<Route> xmlReader(GPX.Version version, Function<? super String, Length> lengthParser) {
        return XMLReader.elem(version == GPX.Version.V10 ? Route::toRouteV10 : Route::toRouteV11, "rte", Route.readers(lengthParser).readers(version));
    }

    private static Route toRouteV11(Object[] v) {
        return new Route((String)v[0], (String)v[1], (String)v[2], (String)v[3], (List)v[4], (UInt)v[5], (String)v[6], XML.extensions((Document)v[7]), (List)v[8]);
    }

    private static Route toRouteV10(Object[] v) {
        return new Route((String)v[0], (String)v[1], (String)v[2], (String)v[3], v[4] != null ? List.of(Link.of((URI)v[4], (String)v[5], null)) : null, (UInt)v[6], (String)v[7], XML.extensions((Document)v[8]), (List)v[9]);
    }

    public static final class Builder
    implements Filter<WayPoint, Route> {
        private String _name;
        private String _comment;
        private String _description;
        private String _source;
        private final List<Link> _links = new ArrayList<Link>();
        private UInt _number;
        private String _type;
        private Document _extensions;
        private final List<WayPoint> _points = new ArrayList<WayPoint>();

        private Builder() {
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this._name);
        }

        public Builder cmt(String comment) {
            this._comment = comment;
            return this;
        }

        public Optional<String> cmt() {
            return Optional.ofNullable(this._comment);
        }

        public Builder desc(String description) {
            this._description = description;
            return this;
        }

        public Optional<String> desc() {
            return Optional.ofNullable(this._description);
        }

        public Builder src(String source) {
            this._source = source;
            return this;
        }

        public Optional<String> src() {
            return Optional.ofNullable(this._source);
        }

        public Builder links(List<Link> links) {
            Lists.copyTo(links, this._links);
            return this;
        }

        public Builder addLink(Link link) {
            this._links.add(Objects.requireNonNull(link));
            return this;
        }

        public Builder addLink(String href) {
            this._links.add(Link.of(href));
            return this;
        }

        public List<Link> links() {
            return new NonNullList<Link>(this._links);
        }

        public Builder number(UInt number) {
            this._number = number;
            return this;
        }

        public Builder number(int number) {
            this._number = UInt.of(number);
            return this;
        }

        public Optional<UInt> number() {
            return Optional.ofNullable(this._number);
        }

        public Builder type(String type) {
            this._type = type;
            return this;
        }

        public Optional<String> type() {
            return Optional.ofNullable(this._type);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public Builder points(List<WayPoint> points) {
            Lists.copyTo(points, this._points);
            return this;
        }

        public Builder addPoint(WayPoint point) {
            this._points.add(Objects.requireNonNull(point));
            return this;
        }

        public Builder addPoint(Consumer<? super WayPoint.Builder> point) {
            WayPoint.Builder builder = WayPoint.builder();
            point.accept(builder);
            return this.addPoint(builder.build());
        }

        public List<WayPoint> points() {
            return new NonNullList<WayPoint>(this._points);
        }

        public Builder filter(Predicate<? super WayPoint> predicate) {
            this.points(this._points.stream().filter(predicate).toList());
            return this;
        }

        public Builder map(Function<? super WayPoint, ? extends WayPoint> mapper) {
            this.points(this._points.stream().map(mapper).map(WayPoint.class::cast).toList());
            return this;
        }

        public Builder flatMap(Function<? super WayPoint, ? extends List<WayPoint>> mapper) {
            this.points(this._points.stream().flatMap((? super T wp) -> ((List)mapper.apply((WayPoint)wp)).stream()).toList());
            return this;
        }

        public Builder listMap(Function<? super List<WayPoint>, ? extends List<WayPoint>> mapper) {
            this.points(mapper.apply(this._points));
            return this;
        }

        @Override
        public Route build() {
            return Route.of(this._name, this._comment, this._description, this._source, this._links, this._number, this._type, this._extensions, this._points);
        }
    }
}

