/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Bounds;
import io.jenetics.jpx.Copyright;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Instants;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.Person;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.TimeFormat;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.w3c.dom.Document;

public final class Metadata
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String _name;
    private final String _description;
    private final Person _author;
    private final Copyright _copyright;
    private final List<Link> _links;
    private final Instant _time;
    private final String _keywords;
    private final Bounds _bounds;
    private final Document _extensions;
    static final XMLReader<Metadata> READER = XMLReader.elem(v -> {
        Metadata metadata = new Metadata((String)v[0], (String)v[1], (Person)v[2], (Copyright)v[3], (List)v[4], (Instant)v[5], (String)v[6], (Bounds)v[7], XML.extensions((Document)v[8]));
        return metadata.isEmpty() ? null : metadata;
    }, "metadata", XMLReader.elem("name"), XMLReader.elem("desc"), Person.reader("author"), Copyright.READER, XMLReader.elems(Link.READER), XMLReader.elem("time").map(TimeFormat::parse), XMLReader.elem("keywords"), Bounds.READER, XMLReader.doc("extensions"));

    private Metadata(String name, String description, Person author, Copyright copyright, List<Link> links, Instant time, String keywords, Bounds bounds, Document extensions) {
        this._name = name;
        this._description = description;
        this._author = author;
        this._copyright = copyright;
        this._links = Lists.copyOf(links);
        this._time = time;
        this._keywords = keywords;
        this._bounds = bounds;
        this._extensions = extensions;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this._description);
    }

    public Optional<Person> getAuthor() {
        return Optional.ofNullable(this._author);
    }

    public Optional<Copyright> getCopyright() {
        return Optional.ofNullable(this._copyright);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public Optional<Instant> getTime() {
        return Optional.ofNullable(this._time);
    }

    public Optional<String> getKeywords() {
        return Optional.ofNullable(this._keywords);
    }

    public Optional<Bounds> getBounds() {
        return Optional.ofNullable(this._bounds);
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    public Builder toBuilder() {
        return Metadata.builder().name(this._name).desc(this._description).author(this._author).copyright(this._copyright).links(this._links).time(this._time).keywords(this._keywords).bounds(this._bounds).extensions(this._extensions);
    }

    public boolean isEmpty() {
        return this._name == null && this._description == null && (this._author == null || this._author.isEmpty()) && this._copyright == null && this._links.isEmpty() && this._time == null && this._keywords == null && this._bounds == null && this._extensions == null;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this._name, this._description, this._author, this._copyright, Lists.hashCode(this._links), Objects.hashCode(this._time), this._keywords, this._bounds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Metadata)) return false;
        Metadata meta = (Metadata)obj;
        if (!Objects.equals(meta._name, this._name)) return false;
        if (!Objects.equals(meta._description, this._description)) return false;
        if (!Objects.equals(meta._author, this._author)) return false;
        if (!Objects.equals(meta._copyright, this._copyright)) return false;
        if (!Lists.equals(meta._links, this._links)) return false;
        if (!Objects.equals(meta._time, this._time)) return false;
        if (!Objects.equals(meta._keywords, this._keywords)) return false;
        if (!Objects.equals(meta._bounds, this._bounds)) return false;
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Metadata of(String name, String description, Person author, Copyright copyright, List<Link> links, Instant time, String keywords, Bounds bounds, Document extensions) {
        return new Metadata(name, description, author == null || author.isEmpty() ? null : author, copyright, links, time, keywords, bounds, XML.extensions(XML.clone(extensions)));
    }

    public static Metadata of(String name, String description, Person author, Copyright copyright, List<Link> links, Instant time, String keywords, Bounds bounds) {
        return Metadata.of(name, description, author, copyright, links, time, keywords, bounds, null);
    }

    private Object writeReplace() {
        return new SerialProxy(11, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeNullableString(this._name, out);
        IO.writeNullableString(this._description, out);
        IO.writeNullable(this._author, Person::write, out);
        IO.writeNullable(this._copyright, Copyright::write, out);
        IO.writes(this._links, Link::write, out);
        IO.writeNullable(this._time, Instants::write, out);
        IO.writeNullableString(this._keywords, out);
        IO.writeNullable(this._bounds, Bounds::write, out);
        IO.writeNullable(this._extensions, IO::write, out);
    }

    static Metadata read(DataInput in) throws IOException {
        return new Metadata(IO.readNullableString(in), IO.readNullableString(in), IO.readNullable(Person::read, in), IO.readNullable(Copyright::read, in), IO.reads(Link::read, in), IO.readNullable(Instants::read, in), IO.readNullableString(in), IO.readNullable(Bounds::read, in), IO.readNullable(IO::readDoc, in));
    }

    static XMLWriter<Metadata> writer(Function<? super Number, String> formatter) {
        return XMLWriter.elem("metadata", XMLWriter.elem("name").map(md -> md._name), XMLWriter.elem("desc").map(md -> md._description), Person.writer("author").map(md -> md._author), Copyright.WRITER.map(md -> md._copyright), XMLWriter.elems(Link.WRITER).map(md -> md._links), XMLWriter.elem("time").map(md -> TimeFormat.format(md._time)), XMLWriter.elem("keywords").map(md -> md._keywords), Bounds.writer(formatter).map(md -> md._bounds), XMLWriter.doc("extensions").map(md -> md._extensions));
    }

    public static final class Builder {
        private String _name;
        private String _description;
        private Person _author;
        private Copyright _copyright;
        private final List<Link> _links = new ArrayList<Link>();
        private Instant _time;
        private String _keywords;
        private Bounds _bounds;
        private Document _extensions;

        private Builder() {
        }

        public Builder metadata(Metadata metadata) {
            this._name = metadata._name;
            this._description = metadata._description;
            this._author = metadata._author;
            this._copyright = metadata._copyright;
            Lists.copyTo(metadata._links, this._links);
            this._time = metadata._time;
            this._keywords = metadata._keywords;
            this._bounds = metadata._bounds;
            this._extensions = metadata._extensions;
            return this;
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this._name);
        }

        public Builder desc(String description) {
            this._description = description;
            return this;
        }

        public Optional<String> desc() {
            return Optional.ofNullable(this._description);
        }

        public Builder author(Person author) {
            this._author = author;
            return this;
        }

        public Builder author(String author) {
            return author != null ? this.author(Person.of(author)) : null;
        }

        public Optional<Person> author() {
            return Optional.ofNullable(this._author);
        }

        public Builder copyright(Copyright copyright) {
            this._copyright = copyright;
            return this;
        }

        public Optional<Copyright> copyright() {
            return Optional.ofNullable(this._copyright);
        }

        public Builder links(List<Link> links) {
            Lists.copyTo(links, this._links);
            return this;
        }

        public Builder addLink(Link link) {
            if (link != null) {
                this._links.add(link);
            }
            return this;
        }

        public Builder addLink(String href) {
            if (href != null) {
                this.addLink(Link.of(href));
            }
            return this;
        }

        public List<Link> links() {
            return new NonNullList<Link>(this._links);
        }

        public Builder time(Instant time) {
            this._time = time;
            return this;
        }

        public Builder time(long millis) {
            this._time = Instant.ofEpochMilli(millis);
            return this;
        }

        public Optional<Instant> time() {
            return Optional.ofNullable(this._time);
        }

        public Builder keywords(String keywords) {
            this._keywords = keywords;
            return this;
        }

        public Optional<String> keywords() {
            return Optional.ofNullable(this._keywords);
        }

        public Builder bounds(Bounds bounds) {
            this._bounds = bounds;
            return this;
        }

        public Optional<Bounds> bounds() {
            return Optional.ofNullable(this._bounds);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public Metadata build() {
            return new Metadata(this._name, this._description, this._author, this._copyright, this._links, this._time, this._keywords, this._bounds, this._extensions);
        }
    }
}

