/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Longitude
extends Number
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final double MIN_DEGREES = -180.0;
    public static final Longitude MIN_VALUE = Longitude.ofDegrees(-180.0);
    public static final double MAX_DEGREES = 180.0;
    public static final Longitude MAX_VALUE = Longitude.ofDegrees(180.0);
    private final double _value;

    private Longitude(double value) {
        if (value < -180.0 || value > 180.0) {
            throw new IllegalArgumentException(String.format("%f is not in range [-180, 180).", value));
        }
        this._value = value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double toRadians() {
        return Math.toRadians(this._value);
    }

    public double toDegrees() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Longitude)) return false;
        Longitude lng = (Longitude)obj;
        if (Double.compare(lng._value, this._value) != 0) return false;
        return true;
    }

    public String toString() {
        return Double.toString(this._value);
    }

    public static Longitude ofDegrees(double degrees) {
        return new Longitude(degrees);
    }

    public static Longitude ofRadians(double radians) {
        return new Longitude(Math.toDegrees(radians));
    }

    static Longitude parse(String value) {
        String lon = Strings.trim(value);
        return lon != null ? Longitude.ofDegrees(Double.parseDouble(lon)) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(10, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._value);
    }

    static Longitude read(DataInput in) throws IOException {
        return new Longitude(in.readDouble());
    }
}

