/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Format;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class Link
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final URI _href;
    private final String _text;
    private final String _type;
    static final XMLWriter<Link> WRITER = XMLWriter.elem("link", XMLWriter.attr("href").map(link -> link._href), XMLWriter.elem("text").map(link -> link._text), XMLWriter.elem("type").map(link -> link._type));
    static final XMLReader<Link> READER = XMLReader.elem(v -> Link.of((URI)v[0], (String)v[1], (String)v[2]), "link", XMLReader.attr("href").map(Format::parseURI), XMLReader.elem("text"), XMLReader.elem("type"));

    private Link(URI href, String text, String type) {
        this._href = Objects.requireNonNull(href);
        this._text = text;
        this._type = type;
    }

    public URI getHref() {
        return this._href;
    }

    public Optional<String> getText() {
        return Optional.ofNullable(this._text);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this._type);
    }

    public int hashCode() {
        return Objects.hash(this._href, this._text, this._type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Link)) return false;
        Link link = (Link)obj;
        if (!Objects.equals(link._href, this._href)) return false;
        if (!Objects.equals(link._text, this._text)) return false;
        if (!Objects.equals(link._type, this._type)) return false;
        return true;
    }

    public String toString() {
        return String.format("Link[%s, text=%s, type=%s]", this._href, this._text, this._type);
    }

    public static Link of(URI href, String text, String type) {
        return new Link(href, text, type);
    }

    public static Link of(String href, String text, String type) {
        return new Link(Format.parseURI(Objects.requireNonNull(href)), text, type);
    }

    public static Link of(URI href) {
        return new Link(href, null, null);
    }

    public static Link of(String href) {
        return new Link(Format.parseURI(Objects.requireNonNull(href)), null, null);
    }

    private Object writeReplace() {
        return new SerialProxy(9, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeString(this._href.toString(), out);
        IO.writeNullableString(this._text, out);
        IO.writeNullableString(this._type, out);
    }

    static Link read(DataInput in) throws IOException {
        return new Link(Format.parseURI(IO.readString(in)), IO.readNullableString(in), IO.readNullableString(in));
    }
}

