/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Bounds;
import io.jenetics.jpx.Email;
import io.jenetics.jpx.Filter;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.IndentingXMLStreamWriter;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.Metadata;
import io.jenetics.jpx.NonCloseableInputStream;
import io.jenetics.jpx.NonCloseableOutputStream;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.Person;
import io.jenetics.jpx.Route;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.TimeFormat;
import io.jenetics.jpx.Track;
import io.jenetics.jpx.WayPoint;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLProvider;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLReaders;
import io.jenetics.jpx.XMLStreamReaderAdapter;
import io.jenetics.jpx.XMLStreamWriterAdapter;
import io.jenetics.jpx.XMLWriter;
import io.jenetics.jpx.XMLWriters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public final class GPX
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String _CREATOR = "JPX - https://github.com/jenetics/jpx";
    private final String _creator;
    private final Version _version;
    private final Metadata _metadata;
    private final List<WayPoint> _wayPoints;
    private final List<Route> _routes;
    private final List<Track> _tracks;
    private final Document _extensions;

    private GPX(Version version, String creator, Metadata metadata, List<WayPoint> wayPoints, List<Route> routes, List<Track> tracks, Document extensions) {
        this._version = Objects.requireNonNull(version);
        this._creator = creator != null ? creator : _CREATOR;
        this._metadata = metadata;
        this._wayPoints = Lists.copyOf(wayPoints);
        this._routes = Lists.copyOf(routes);
        this._tracks = Lists.copyOf(tracks);
        this._extensions = extensions;
    }

    public String getVersion() {
        return this._version._value;
    }

    public String getCreator() {
        return this._creator;
    }

    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this._metadata);
    }

    public List<WayPoint> getWayPoints() {
        return this._wayPoints;
    }

    public Stream<WayPoint> wayPoints() {
        return this._wayPoints.stream();
    }

    public List<Route> getRoutes() {
        return this._routes;
    }

    public Stream<Route> routes() {
        return this._routes.stream();
    }

    public List<Track> getTracks() {
        return this._tracks;
    }

    public Stream<Track> tracks() {
        return this._tracks.stream();
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    public Builder toBuilder() {
        return GPX.builder(this._version, this._creator).metadata(this._metadata).wayPoints(this._wayPoints).routes(this._routes).tracks(this._tracks).extensions(this._extensions);
    }

    public String toString() {
        return String.format("GPX[way-points=%s, routes=%s, tracks=%s]", this.getWayPoints().size(), this.getRoutes().size(), this.getTracks().size());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._creator, this._version, this._metadata, this._wayPoints, this._routes, this._tracks});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof GPX)) return false;
        GPX gpx = (GPX)obj;
        if (!Objects.equals(gpx._creator, this._creator)) return false;
        if (!Objects.equals((Object)gpx._version, (Object)this._version)) return false;
        if (!Objects.equals(gpx._metadata, this._metadata)) return false;
        if (!Objects.equals(gpx._wayPoints, this._wayPoints)) return false;
        if (!Objects.equals(gpx._routes, this._routes)) return false;
        if (!Objects.equals(gpx._tracks, this._tracks)) return false;
        return true;
    }

    public static Builder builder(Version version, String creator) {
        return new Builder(version, creator);
    }

    public static Builder builder(String creator) {
        return GPX.builder(Version.V11, creator);
    }

    public static Builder builder() {
        return GPX.builder(Version.V11, _CREATOR);
    }

    public static GPX of(Version version, String creator, Metadata metadata, List<WayPoint> wayPoints, List<Route> routes, List<Track> tracks, Document extensions) {
        return new GPX(version, creator, metadata == null || metadata.isEmpty() ? null : metadata, wayPoints, routes, tracks, XML.extensions(XML.clone(extensions)));
    }

    public static GPX of(String creator, Metadata metadata, List<WayPoint> wayPoints, List<Route> routes, List<Track> tracks) {
        return GPX.of(Version.V11, creator, metadata, wayPoints, routes, tracks, null);
    }

    public static GPX of(String creator, Metadata metadata, List<WayPoint> wayPoints, List<Route> routes, List<Track> tracks, Document extensions) {
        return GPX.of(Version.V11, creator, metadata, wayPoints, routes, tracks, extensions);
    }

    public static GPX of(Version version, String creator, Metadata metadata, List<WayPoint> wayPoints, List<Route> routes, List<Track> tracks) {
        return GPX.of(version, creator, metadata == null || metadata.isEmpty() ? null : metadata, wayPoints, routes, tracks, null);
    }

    private Object writeReplace() {
        return new SerialProxy(6, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeString(this._version.getValue(), out);
        IO.writeString(this._creator, out);
        IO.writeNullable(this._metadata, Metadata::write, out);
        IO.writes(this._wayPoints, WayPoint::write, out);
        IO.writes(this._routes, Route::write, out);
        IO.writes(this._tracks, Track::write, out);
        IO.writeNullable(this._extensions, IO::write, out);
    }

    static GPX read(DataInput in) throws IOException {
        return new GPX(Version.of(IO.readString(in)), IO.readString(in), IO.readNullable(Metadata::read, in), IO.reads(WayPoint::read, in), IO.reads(Route::read, in), IO.reads(Track::read, in), IO.readNullable(IO::readDoc, in));
    }

    private static String name(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getName).orElse(null);
    }

    private static String desc(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getDescription).orElse(null);
    }

    private static String author(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getAuthor).flatMap(Person::getName).orElse(null);
    }

    private static String email(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getAuthor).flatMap(Person::getEmail).map(Email::getAddress).orElse(null);
    }

    private static String url(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getAuthor).flatMap(Person::getLink).map(Link::getHref).map(URI::toString).orElse(null);
    }

    private static String urlname(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getAuthor).flatMap(Person::getLink).flatMap(Link::getText).orElse(null);
    }

    private static String time(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getTime).map(TimeFormat::format).orElse(null);
    }

    private static String keywords(GPX gpx) {
        return gpx.getMetadata().flatMap(Metadata::getKeywords).orElse(null);
    }

    private static XMLWriters<GPX> writers(Function<? super Number, String> formatter) {
        return new XMLWriters<GPX>().v00(XMLWriter.attr("version").map(gpx -> gpx._version._value)).v00(XMLWriter.attr("creator").map(GPX::getCreator)).v11(XMLWriter.ns(Version.V11.getNamespaceURI())).v10(XMLWriter.ns(Version.V10.getNamespaceURI())).v11(Metadata.writer(formatter).flatMap(GPX::getMetadata)).v10(XMLWriter.elem("name").map(GPX::name)).v10(XMLWriter.elem("desc").map(GPX::desc)).v10(XMLWriter.elem("author").map(GPX::author)).v10(XMLWriter.elem("email").map(GPX::email)).v10(XMLWriter.elem("url").map(GPX::url)).v10(XMLWriter.elem("urlname").map(GPX::urlname)).v10(XMLWriter.elem("time").map(GPX::time)).v10(XMLWriter.elem("keywords").map(GPX::keywords)).v10(XMLWriter.elems(WayPoint.xmlWriter(Version.V10, "wpt", formatter)).map(GPX::getWayPoints)).v11(XMLWriter.elems(WayPoint.xmlWriter(Version.V11, "wpt", formatter)).map(GPX::getWayPoints)).v10(XMLWriter.elems(Route.xmlWriter(Version.V10, formatter)).map(GPX::getRoutes)).v11(XMLWriter.elems(Route.xmlWriter(Version.V11, formatter)).map(GPX::getRoutes)).v10(XMLWriter.elems(Track.xmlWriter(Version.V10, formatter)).map(GPX::getTracks)).v11(XMLWriter.elems(Track.xmlWriter(Version.V11, formatter)).map(GPX::getTracks)).v00(XMLWriter.doc("extensions").flatMap(GPX::getExtensions));
    }

    private static XMLReaders readers(Function<? super String, Length> lengthParser) {
        return new XMLReaders().v00(XMLReader.attr("version").map(Version::of, Version.V11)).v00(XMLReader.attr("creator")).v11(Metadata.READER).v10(XMLReader.elem("name")).v10(XMLReader.elem("desc")).v10(XMLReader.elem("author")).v10(XMLReader.elem("email")).v10(XMLReader.elem("url")).v10(XMLReader.elem("urlname")).v10(XMLReader.elem("time").map(TimeFormat::parse)).v10(XMLReader.elem("keywords")).v10(Bounds.READER).v10(XMLReader.elems(WayPoint.xmlReader(Version.V10, "wpt", lengthParser))).v11(XMLReader.elems(WayPoint.xmlReader(Version.V11, "wpt", lengthParser))).v10(XMLReader.elems(Route.xmlReader(Version.V10, lengthParser))).v11(XMLReader.elems(Route.xmlReader(Version.V11, lengthParser))).v10(XMLReader.elems(Track.xmlReader(Version.V10, lengthParser))).v11(XMLReader.elems(Track.xmlReader(Version.V11, lengthParser))).v00(XMLReader.doc("extensions"));
    }

    static XMLWriter<GPX> xmlWriter(Version version, Function<? super Number, String> formatter) {
        return XMLWriter.elem("gpx", GPX.writers(formatter).writers(version));
    }

    static XMLReader<GPX> xmlReader(Version version, Function<? super String, Length> lengthParser) {
        return XMLReader.elem(version == Version.V10 ? GPX::toGPXv10 : GPX::toGPXv11, "gpx", GPX.readers(lengthParser).readers(version));
    }

    private static GPX toGPXv11(Object[] v) {
        return new GPX((Version)((Object)v[0]), (String)v[1], (Metadata)v[2], (List)v[3], (List)v[4], (List)v[5], XML.extensions((Document)v[6]));
    }

    private static GPX toGPXv10(Object[] v) {
        return new GPX((Version)((Object)v[0]), (String)v[1], Metadata.of((String)v[2], (String)v[3], Person.of((String)v[4], v[5] != null ? Email.of((String)v[5]) : null, v[6] != null ? Link.of((String)v[6], (String)v[7], null) : null), null, null, (Instant)v[8], (String)v[9], (Bounds)v[10]), (List)v[11], (List)v[12], (List)v[13], XML.extensions((Document)v[14]));
    }

    public static void write(GPX gpx, Path path) throws IOException {
        Writer.DEFAULT.write(gpx, path);
    }

    public static GPX read(Path path) throws IOException {
        return Reader.DEFAULT.read(path);
    }

    public static enum Version {
        V10("1.0", "http://www.topografix.com/GPX/1/0"),
        V11("1.1", "http://www.topografix.com/GPX/1/1");

        private final String _value;
        private final String _namespaceURI;

        private Version(String value, String namespaceURI) {
            this._value = value;
            this._namespaceURI = namespaceURI;
        }

        public String getValue() {
            return this._value;
        }

        public String getNamespaceURI() {
            return this._namespaceURI;
        }

        public static Version of(String version) {
            return switch (version) {
                case "1.0" -> V10;
                case "1.1" -> V11;
                default -> throw new IllegalArgumentException(String.format("Unknown version string: '%s'.", version));
            };
        }
    }

    public static final class Builder {
        private String _creator;
        private Version _version;
        private Metadata _metadata;
        private final List<WayPoint> _wayPoints = new ArrayList<WayPoint>();
        private final List<Route> _routes = new ArrayList<Route>();
        private final List<Track> _tracks = new ArrayList<Track>();
        private Document _extensions;

        private Builder(Version version, String creator) {
            this._version = Objects.requireNonNull(version);
            this._creator = Objects.requireNonNull(creator);
        }

        public Builder creator(String creator) {
            this._creator = Objects.requireNonNull(creator);
            return this;
        }

        public String creator() {
            return this._creator;
        }

        public Builder version(Version version) {
            this._version = Objects.requireNonNull(version);
            return this;
        }

        public String version() {
            return this._version._value;
        }

        public Builder metadata(Metadata metadata) {
            this._metadata = metadata;
            return this;
        }

        public Builder metadata(Consumer<? super Metadata.Builder> metadata) {
            Metadata.Builder builder = Metadata.builder();
            metadata.accept(builder);
            Metadata md = builder.build();
            this._metadata = md.isEmpty() ? null : md;
            return this;
        }

        public Optional<Metadata> metadata() {
            return Optional.ofNullable(this._metadata);
        }

        public Builder wayPoints(List<WayPoint> wayPoints) {
            Lists.copyTo(wayPoints, this._wayPoints);
            return this;
        }

        public Builder addWayPoint(WayPoint wayPoint) {
            this._wayPoints.add(Objects.requireNonNull(wayPoint));
            return this;
        }

        public Builder addWayPoint(Consumer<? super WayPoint.Builder> wayPoint) {
            WayPoint.Builder builder = WayPoint.builder();
            wayPoint.accept(builder);
            return this.addWayPoint(builder.build());
        }

        public List<WayPoint> wayPoints() {
            return new NonNullList<WayPoint>(this._wayPoints);
        }

        public Builder routes(List<Route> routes) {
            Lists.copyTo(routes, this._routes);
            return this;
        }

        public Builder addRoute(Route route) {
            this._routes.add(Objects.requireNonNull(route));
            return this;
        }

        public Builder addRoute(Consumer<? super Route.Builder> route) {
            Route.Builder builder = Route.builder();
            route.accept(builder);
            return this.addRoute(builder.build());
        }

        public List<Route> routes() {
            return new NonNullList<Route>(this._routes);
        }

        public Builder tracks(List<Track> tracks) {
            Lists.copyTo(tracks, this._tracks);
            return this;
        }

        public Builder addTrack(Track track) {
            this._tracks.add(Objects.requireNonNull(track));
            return this;
        }

        public Builder addTrack(Consumer<? super Track.Builder> track) {
            Track.Builder builder = Track.builder();
            track.accept(builder);
            return this.addTrack(builder.build());
        }

        public List<Track> tracks() {
            return new NonNullList<Track>(this._tracks);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public GPX build() {
            return GPX.of(this._version, this._creator, this._metadata, this._wayPoints, this._routes, this._tracks, this._extensions);
        }

        public Filter<WayPoint, Builder> wayPointFilter() {
            return new Filter<WayPoint, Builder>(){

                @Override
                public Filter<WayPoint, Builder> filter(Predicate<? super WayPoint> predicate) {
                    this.wayPoints(_wayPoints.stream().filter(predicate).toList());
                    return this;
                }

                @Override
                public Filter<WayPoint, Builder> map(Function<? super WayPoint, ? extends WayPoint> mapper) {
                    this.wayPoints(_wayPoints.stream().map(mapper).map(WayPoint.class::cast).toList());
                    return this;
                }

                @Override
                public Filter<WayPoint, Builder> flatMap(Function<? super WayPoint, ? extends List<WayPoint>> mapper) {
                    this.wayPoints(_wayPoints.stream().flatMap((? super T wp) -> ((List)mapper.apply((WayPoint)wp)).stream()).toList());
                    return this;
                }

                @Override
                public Filter<WayPoint, Builder> listMap(Function<? super List<WayPoint>, ? extends List<WayPoint>> mapper) {
                    this.wayPoints(mapper.apply(_wayPoints));
                    return this;
                }

                @Override
                public Builder build() {
                    return this;
                }
            };
        }

        public Filter<Route, Builder> routeFilter() {
            return new Filter<Route, Builder>(){

                @Override
                public Filter<Route, Builder> filter(Predicate<? super Route> predicate) {
                    this.routes(_routes.stream().filter(predicate).toList());
                    return this;
                }

                @Override
                public Filter<Route, Builder> map(Function<? super Route, ? extends Route> mapper) {
                    this.routes(_routes.stream().map(mapper).map(Route.class::cast).toList());
                    return this;
                }

                @Override
                public Filter<Route, Builder> flatMap(Function<? super Route, ? extends List<Route>> mapper) {
                    this.routes(_routes.stream().flatMap((? super T route) -> ((List)mapper.apply((Route)route)).stream()).toList());
                    return this;
                }

                @Override
                public Filter<Route, Builder> listMap(Function<? super List<Route>, ? extends List<Route>> mapper) {
                    this.routes(mapper.apply(_routes));
                    return this;
                }

                @Override
                public Builder build() {
                    return this;
                }
            };
        }

        public Filter<Track, Builder> trackFilter() {
            return new Filter<Track, Builder>(){

                @Override
                public Filter<Track, Builder> filter(Predicate<? super Track> predicate) {
                    this.tracks(_tracks.stream().filter(predicate).toList());
                    return this;
                }

                @Override
                public Filter<Track, Builder> map(Function<? super Track, ? extends Track> mapper) {
                    this.tracks(_tracks.stream().map(mapper).map(Track.class::cast).toList());
                    return this;
                }

                @Override
                public Filter<Track, Builder> flatMap(Function<? super Track, ? extends List<Track>> mapper) {
                    this.tracks(_tracks.stream().flatMap((? super T track) -> ((List)mapper.apply((Track)track)).stream()).toList());
                    return this;
                }

                @Override
                public Filter<Track, Builder> listMap(Function<? super List<Track>, ? extends List<Track>> mapper) {
                    this.tracks(mapper.apply(_tracks));
                    return this;
                }

                @Override
                public Builder build() {
                    return this;
                }
            };
        }
    }

    public static final class Writer {
        public static final int DEFAULT_FRACTION_DIGITS = 8;
        public static final Writer DEFAULT = new Writer(Indent.SPACE4, 8);
        private final Indent _indent;
        private final int _maximumFractionDigits;

        private Writer(Indent indent, int maximumFractionDigits) {
            this._indent = Objects.requireNonNull(indent);
            this._maximumFractionDigits = maximumFractionDigits;
        }

        public Indent indent() {
            return this._indent;
        }

        public int maximumFractionDigits() {
            return this._maximumFractionDigits;
        }

        public void write(GPX gpx, Result result) throws IOException {
            try {
                XMLStreamWriterAdapter output;
                XMLStreamWriter writer = XMLProvider.provider().xmlOutputFactory().createXMLStreamWriter(result);
                try (XMLStreamWriterAdapter xMLStreamWriterAdapter = output = this._indent.value() == null ? new XMLStreamWriterAdapter(writer) : new IndentingXMLStreamWriter(writer, this._indent.value());){
                    NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
                    format.setMaximumFractionDigits(this._maximumFractionDigits);
                    format.setGroupingUsed(false);
                    Function<Number, String> formatter = value -> value != null ? format.format(value) : null;
                    output.writeStartDocument("UTF-8", "1.0");
                    GPX.xmlWriter(gpx._version, formatter).write(output, gpx);
                    output.writeEndDocument();
                }
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }

        public void write(GPX gpx, OutputStream output) throws IOException {
            NonCloseableOutputStream wrapper = new NonCloseableOutputStream(output);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)wrapper, StandardCharsets.UTF_8);){
                this.write(gpx, new StreamResult(writer));
            }
        }

        public void write(GPX gpx, Path path) throws IOException {
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                this.write(gpx, out);
            }
        }

        public void write(GPX gpx, File file) throws IOException {
            this.write(gpx, file.toPath());
        }

        public void write(GPX gpx, String path) throws IOException {
            this.write(gpx, Path.of(path, new String[0]));
        }

        public String toString(GPX gpx) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.write(gpx, out);
                return out.toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        byte[] toByteArray(GPX gpx) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputStream dout = new DataOutputStream(out);){
                gpx.write(dout);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return out.toByteArray();
        }

        public static Writer of(Indent indent, int maximumFractionDigits) {
            return new Writer(indent, maximumFractionDigits);
        }

        public static Writer of(Indent indent) {
            return new Writer(indent, 8);
        }

        public record Indent(String value) {
            public static final Indent NULL = new Indent(null);
            public static final Indent NONE = new Indent("");
            public static final Indent SPACE4 = new Indent("    ");
            public static final Indent SPACE2 = new Indent("  ");
            public static final Indent TAB1 = new Indent("\t");
        }
    }

    public static final class Reader {
        public static final Reader DEFAULT = Reader.of(Version.V11, Mode.STRICT);
        private final Version _version;
        private final Mode _mode;

        private Reader(Version version, Mode mode) {
            this._version = Objects.requireNonNull(version);
            this._mode = Objects.requireNonNull(mode);
        }

        public Version version() {
            return this._version;
        }

        public Mode mode() {
            return this._mode;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public GPX read(Source source) throws IOException {
            try {
                XMLStreamReader reader = XMLProvider.provider().xmlInputFactory().createXMLStreamReader(source);
                try (XMLStreamReaderAdapter input = new XMLStreamReaderAdapter(reader);){
                    if (!input.hasNext()) throw new InvalidObjectException("No 'gpx' element found.");
                    input.next();
                    NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
                    Function<String, Length> lengthParser = string -> Length.parse(string, format);
                    GPX gPX = GPX.xmlReader(this._version, lengthParser).read(input, this._mode == Mode.LENIENT);
                    return gPX;
                }
                catch (XMLStreamException e) {
                    throw new InvalidObjectException("Invalid GPX: " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    InvalidObjectException ioe = new InvalidObjectException(e.getMessage());
                    throw (InvalidObjectException)ioe.initCause(e);
                }
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }

        public GPX read(InputStream input) throws IOException {
            NonCloseableInputStream wrapper = new NonCloseableInputStream(input);
            try (InputStreamReader reader = new InputStreamReader((InputStream)wrapper, StandardCharsets.UTF_8);){
                GPX gPX = this.read(new StreamSource(reader));
                return gPX;
            }
        }

        public GPX read(Path path) throws IOException {
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                GPX gPX = this.read(input);
                return gPX;
            }
        }

        public GPX read(File file) throws IOException {
            return this.read(file.toPath());
        }

        public GPX read(String path) throws IOException {
            return this.read(Paths.get(path, new String[0]));
        }

        public GPX fromString(String xml) {
            try {
                return this.read(new ByteArrayInputStream(xml.getBytes()));
            }
            catch (InvalidObjectException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IllegalArgumentException) {
                    IllegalArgumentException iae = (IllegalArgumentException)throwable;
                    throw iae;
                }
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        GPX formByteArray(byte[] bytes, int offset, int length) {
            GPX gPX;
            ByteArrayInputStream in = new ByteArrayInputStream(bytes, offset, length);
            DataInputStream din = new DataInputStream(in);
            try {
                gPX = GPX.read(din);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        din.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            din.close();
            return gPX;
        }

        GPX formByteArray(byte[] bytes) {
            return this.formByteArray(bytes, 0, bytes.length);
        }

        public static Reader of(Version version, Mode mode) {
            return new Reader(version, mode);
        }

        public static Reader of(Mode mode) {
            return new Reader(Version.V11, mode);
        }

        public static enum Mode {
            LENIENT,
            STRICT;

        }
    }
}

