/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Year;

final class Format {
    private Format() {
    }

    static Double parseDouble(String value) {
        String d = Strings.trim(value);
        return d != null ? Double.valueOf(Double.parseDouble(d)) : null;
    }

    static Duration parseDuration(String value) {
        String duration = Strings.trim(value);
        return duration != null ? Duration.ofSeconds(Long.parseLong(duration)) : null;
    }

    static String toDurationString(Duration duration) {
        return duration != null ? Long.toString(duration.getSeconds()) : null;
    }

    static Year parseYear(String value) {
        String year = Strings.trim(value);
        return year != null ? Year.of(Integer.parseInt(year)) : null;
    }

    static String toYearString(Year year) {
        return year != null ? Integer.toString(year.getValue()) : null;
    }

    static URI parseURI(String value) {
        try {
            String uri = Strings.trim(value);
            return uri != null ? new URI(uri) : null;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid URI value: '%s'.", value));
        }
    }

    static String toUriString(URI uri) {
        return uri != null ? uri.toString() : null;
    }

    static String toIntString(Number number) {
        return number != null ? Integer.toString(number.intValue()) : null;
    }
}

