/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.GPX;
import io.jenetics.jpx.Metadata;
import io.jenetics.jpx.Route;
import io.jenetics.jpx.Track;
import io.jenetics.jpx.TrackSegment;
import io.jenetics.jpx.WayPoint;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Filters {
    private Filters() {
    }

    public static List<TrackSegment> mergeSegments(List<TrackSegment> segments) {
        List<WayPoint> points = segments.stream().flatMap(TrackSegment::points).toList();
        return List.of(TrackSegment.of(points));
    }

    public static List<Track> mergeTracks(List<Track> tracks) {
        List<TrackSegment> segments = tracks.stream().flatMap(Track::segments).toList();
        return tracks.isEmpty() ? List.of() : List.of(tracks.get(0).toBuilder().segments(segments).build());
    }

    public static List<Track> fullyMergeTracks(List<Track> tracks) {
        List<WayPoint> points = tracks.stream().flatMap(Track::segments).flatMap(TrackSegment::points).toList();
        return tracks.isEmpty() ? List.of() : List.of(tracks.get(0).toBuilder().segments(List.of(TrackSegment.of(points))).build());
    }

    public static GPX nonEmptyGPX(GPX gpx) {
        return gpx.toBuilder().routeFilter().listMap(Filters::nonEmptyRoutes).build().trackFilter().listMap(Filters::nonEmptyTracks).build().metadata((Metadata)gpx.getMetadata().filter(Metadata::nonEmpty).orElse(null)).build();
    }

    public static List<Route> nonEmptyRoutes(List<Route> routes) {
        return routes.stream().filter(Route::nonEmpty).toList();
    }

    public static List<Track> nonEmptyTracks(List<Track> tracks) {
        return tracks.stream().map(track -> ((Track.Builder)track.toBuilder().listMap(Filters::nonEmptySegments)).build()).filter(Track::nonEmpty).toList();
    }

    public static List<TrackSegment> nonEmptySegments(List<TrackSegment> segments) {
        return segments.stream().filter(TrackSegment::nonEmpty).toList();
    }

    static List<Track> splitByDay(Track track) {
        return Filters.splitWayPointsByDay(track.segments().flatMap(TrackSegment::points)).stream().map(TrackSegment::of).map(segment -> Track.builder().addSegment((TrackSegment)segment).build()).toList();
    }

    private static List<List<WayPoint>> splitWayPointsByDay(Stream<WayPoint> points) {
        Map<LocalDate, List<WayPoint>> parts = points.collect(Collectors.groupingBy(wp -> wp.getTime().map(i -> LocalDate.ofInstant(i, ZoneOffset.UTC)).orElse(LocalDate.MIN)));
        return parts.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
    }

    static List<TrackSegment> splitByDay(TrackSegment segment) {
        return Filters.splitWayPointsByDay(segment.points()).stream().map(TrackSegment::of).toList();
    }
}

