/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.IO;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;

public final class Email
implements Comparable<Email>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String _id;
    private final String _domain;
    static final XMLWriter<Email> WRITER = XMLWriter.elem("email", XMLWriter.attr("id").map(email -> email._id), XMLWriter.attr("domain").map(email -> email._domain));
    static final XMLReader<Email> READER = XMLReader.elem(v -> Email.of((String)v[0], (String)v[1]), "email", XMLReader.attr("id"), XMLReader.attr("domain"));

    private Email(String id, String domain) {
        this._id = Objects.requireNonNull(id);
        this._domain = Objects.requireNonNull(domain);
    }

    public String getID() {
        return this._id;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getAddress() {
        return this._id + "@" + this._domain;
    }

    @Override
    public int compareTo(Email other) {
        int cmp = this._domain.compareTo(other._domain);
        if (cmp == 0) {
            cmp = this._id.compareTo(other._id);
        }
        return cmp;
    }

    public int hashCode() {
        return Objects.hash(this._id, this._domain);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Email)) return false;
        Email email = (Email)obj;
        if (!Objects.equals(email._id, this._id)) return false;
        if (!Objects.equals(email._domain, this._domain)) return false;
        return true;
    }

    public String toString() {
        return this.getAddress();
    }

    public static Email of(String id, String domain) {
        return new Email(id, domain);
    }

    public static Email of(String address) {
        if (address.length() < 3) {
            throw new IllegalArgumentException(String.format("Invalid email: '%s'.", address));
        }
        int index = address.indexOf(64);
        if (index == -1 || index == 0 || index == address.length() - 1) {
            throw new IllegalArgumentException(String.format("Invalid email: '%s'.", address));
        }
        return new Email(address.substring(0, index), address.substring(index + 1));
    }

    private Object writeReplace() {
        return new SerialProxy(5, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeString(this.getAddress(), out);
    }

    static Email read(DataInput in) throws IOException {
        return Email.of(IO.readString(in));
    }
}

