/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.IO;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class DGPSStation
extends Number
implements Comparable<DGPSStation>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 1023;
    private final int _value;

    private DGPSStation(int value) {
        if (value < 0 || value > 1023) {
            throw new IllegalArgumentException(String.format("%d is out of range [0, 1023].", value));
        }
        this._value = value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public int compareTo(DGPSStation other) {
        return Integer.compare(this._value, other._value);
    }

    public int hashCode() {
        return Integer.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof DGPSStation)) return false;
        DGPSStation dgps = (DGPSStation)obj;
        if (dgps._value != this._value) return false;
        return true;
    }

    public String toString() {
        return Integer.toString(this._value);
    }

    public static DGPSStation of(int value) {
        return new DGPSStation(value);
    }

    static DGPSStation parse(String value) {
        String stat = Strings.trim(value);
        return stat != null ? DGPSStation.of(Integer.parseInt(stat)) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(4, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeInt(this._value, out);
    }

    static DGPSStation read(DataInput in) throws IOException {
        return new DGPSStation(IO.readInt(in));
    }
}

