/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Format;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Year;
import java.util.Objects;
import java.util.Optional;

public final class Copyright
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String _author;
    private final Year _year;
    private final URI _license;
    static final XMLWriter<Copyright> WRITER = XMLWriter.elem("copyright", XMLWriter.attr("author").map(cr -> cr._author), XMLWriter.elem("year").map(cr -> Format.toYearString(cr._year)), XMLWriter.elem("license").map(cr -> Format.toUriString(cr._license)));
    static final XMLReader<Copyright> READER = XMLReader.elem(v -> Copyright.of((String)v[0], (Year)v[1], (URI)v[2]), "copyright", XMLReader.attr("author"), XMLReader.elem("year").map(Format::parseYear), XMLReader.elem("license").map(Format::parseURI));

    private Copyright(String author, Year year, URI license) {
        this._author = Objects.requireNonNull(author);
        this._year = year;
        this._license = license;
    }

    public String getAuthor() {
        return this._author;
    }

    public Optional<Year> getYear() {
        return Optional.ofNullable(this._year);
    }

    public Optional<URI> getLicense() {
        return Optional.ofNullable(this._license);
    }

    public int hashCode() {
        return Objects.hash(this._author, this._year, this._license);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Copyright)) return false;
        Copyright cr = (Copyright)obj;
        if (!Objects.equals(cr._author, this._author)) return false;
        if (!Objects.equals(cr._year, this._year)) return false;
        if (!Objects.equals(cr._license, this._license)) return false;
        return true;
    }

    public String toString() {
        return this._author + this.getYear().map(y -> " (c) " + y).orElse("");
    }

    public static Copyright of(String author, Year year, URI license) {
        return new Copyright(author, year, license);
    }

    public static Copyright of(String author, int year, URI license) {
        return new Copyright(author, Year.of(year), license);
    }

    public static Copyright of(String author, int year, String license) {
        return new Copyright(author, Year.of(year), Format.parseURI(license));
    }

    public static Copyright of(String author, Year year) {
        return new Copyright(author, year, null);
    }

    public static Copyright of(String author, int year) {
        return new Copyright(author, Year.of(year), null);
    }

    public static Copyright of(String author, URI license) {
        return new Copyright(author, null, license);
    }

    public static Copyright of(String author) {
        return new Copyright(author, null, null);
    }

    private Object writeReplace() {
        return new SerialProxy(2, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeString(this._author, out);
        out.writeBoolean(this._year != null);
        if (this._year != null) {
            IO.writeInt(this._year.getValue(), out);
        }
        IO.writeNullableString(this._license != null ? this._license.toString() : null, out);
    }

    static Copyright read(DataInput in) throws IOException {
        return new Copyright(IO.readString(in), in.readBoolean() ? Year.of(IO.readInt(in)) : null, Format.parseURI(IO.readNullableString(in)));
    }
}

