/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.Point;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;

public final class Bounds
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Latitude _minLatitude;
    private final Longitude _minLongitude;
    private final Latitude _maxLatitude;
    private final Longitude _maxLongitude;
    static final XMLReader<Bounds> READER = XMLReader.elem(v -> Bounds.of((Latitude)v[0], (Longitude)v[1], (Latitude)v[2], (Longitude)v[3]), "bounds", XMLReader.attr("minlat").map(Latitude::parse), XMLReader.attr("minlon").map(Longitude::parse), XMLReader.attr("maxlat").map(Latitude::parse), XMLReader.attr("maxlon").map(Longitude::parse));

    private Bounds(Latitude minLatitude, Longitude minLongitude, Latitude maxLatitude, Longitude maxLongitude) {
        this._minLatitude = Objects.requireNonNull(minLatitude);
        this._minLongitude = Objects.requireNonNull(minLongitude);
        this._maxLatitude = Objects.requireNonNull(maxLatitude);
        this._maxLongitude = Objects.requireNonNull(maxLongitude);
    }

    public Latitude getMinLatitude() {
        return this._minLatitude;
    }

    public Longitude getMinLongitude() {
        return this._minLongitude;
    }

    public Latitude getMaxLatitude() {
        return this._maxLatitude;
    }

    public Longitude getMaxLongitude() {
        return this._maxLongitude;
    }

    public int hashCode() {
        return Objects.hash(this._minLatitude, this._minLongitude, this._maxLatitude, this._maxLongitude);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Bounds)) return false;
        Bounds bounds = (Bounds)obj;
        if (!Objects.equals(bounds._minLatitude, this._minLatitude)) return false;
        if (!Objects.equals(bounds._minLongitude, this._minLongitude)) return false;
        if (!Objects.equals(bounds._maxLatitude, this._maxLatitude)) return false;
        if (!Objects.equals(bounds._maxLongitude, this._maxLongitude)) return false;
        return true;
    }

    public String toString() {
        return String.format("[%s, %s][%s, %s]", this._minLatitude, this._minLongitude, this._maxLatitude, this._maxLongitude);
    }

    public static <P extends Point> Collector<P, ?, Bounds> toBounds() {
        return Collector.of(() -> {
            double[] a = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308};
            return a;
        }, (a, b) -> {
            a[0] = Math.min(b.getLatitude().doubleValue(), a[0]);
            a[1] = Math.min(b.getLongitude().doubleValue(), a[1]);
            a[2] = Math.max(b.getLatitude().doubleValue(), a[2]);
            a[3] = Math.max(b.getLongitude().doubleValue(), a[3]);
        }, (a, b) -> {
            a[0] = Math.min(a[0], b[0]);
            a[1] = Math.min(a[1], b[1]);
            a[2] = Math.max(a[2], b[2]);
            a[3] = Math.max(a[3], b[3]);
            return a;
        }, a -> a[0] == Double.MAX_VALUE ? null : Bounds.of(a[0], a[1], a[2], a[3]), new Collector.Characteristics[0]);
    }

    public static Bounds of(Latitude minLatitude, Longitude minLongitude, Latitude maxLatitude, Longitude maxLongitude) {
        return new Bounds(minLatitude, minLongitude, maxLatitude, maxLongitude);
    }

    public static Bounds of(double minLatitudeDegree, double minLongitudeDegree, double maxLatitudeDegree, double maxLongitudeDegree) {
        return new Bounds(Latitude.ofDegrees(minLatitudeDegree), Longitude.ofDegrees(minLongitudeDegree), Latitude.ofDegrees(maxLatitudeDegree), Longitude.ofDegrees(maxLongitudeDegree));
    }

    private Object writeReplace() {
        return new SerialProxy(1, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._minLatitude.toDegrees());
        out.writeDouble(this._minLongitude.toDegrees());
        out.writeDouble(this._maxLatitude.toDegrees());
        out.writeDouble(this._maxLongitude.toDegrees());
    }

    static Bounds read(DataInput in) throws IOException {
        return Bounds.of(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
    }

    static XMLWriter<Bounds> writer(Function<? super Number, String> formatter) {
        return XMLWriter.elem("bounds", XMLWriter.attr("minlat").map(b -> formatter.apply(b.getMinLatitude())), XMLWriter.attr("minlon").map(b -> formatter.apply(b.getMinLongitude())), XMLWriter.attr("maxlat").map(b -> formatter.apply(b.getMaxLatitude())), XMLWriter.attr("maxlon").map(b -> formatter.apply(b.getMaxLongitude())));
    }
}

