/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl;

import io.javalin.community.ssl.SslConfigException;
import io.javalin.community.ssl.TlsConfig;
import io.javalin.community.ssl.TrustConfig;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.util.function.Consumer;
import javax.net.ssl.X509ExtendedKeyManager;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import nl.altindag.ssl.pem.util.PemUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.eclipse.jetty.server.ServerConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u00029:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020 2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J$\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\nH\u0007J$\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\nH\u0007J$\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\nH\u0007J$\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\nH\u0007J$\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020'2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\nH\u0007J$\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\nH\u0007J$\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u00107\u001a\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004R.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0003\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006;"}, d2={"Lio/javalin/community/ssl/SslConfig;", "", "()V", "<set-?>", "Ljava/util/function/Consumer;", "Lorg/eclipse/jetty/server/ServerConnector;", "configConnectors", "getConfigConnectors", "()Ljava/util/function/Consumer;", "host", "", "http2", "", "insecure", "insecurePort", "", "pvt", "Lio/javalin/community/ssl/SslConfig$PrivateConfig;", "getPvt", "()Lio/javalin/community/ssl/SslConfig$PrivateConfig;", "redirect", "secure", "securePort", "securityProvider", "Ljava/security/Provider;", "sniHostCheck", "tlsConfig", "Lio/javalin/community/ssl/TlsConfig;", "Lio/javalin/community/ssl/TrustConfig;", "trustConfig", "getTrustConfig", "()Lio/javalin/community/ssl/TrustConfig;", "", "keystoreFromClasspath", "keyStoreFile", "keyStorePassword", "identityPassword", "keystoreFromInputStream", "keyStoreInputStream", "Ljava/io/InputStream;", "keystoreFromPath", "keyStorePath", "pemFromClasspath", "certificateFile", "privateKeyFile", "password", "pemFromInputStream", "certificateInputStream", "privateKeyInputStream", "pemFromPath", "certificatePath", "privateKeyPath", "pemFromString", "certificateString", "privateKeyString", "withTrustConfig", "trustConfigConsumer", "LoadedIdentity", "PrivateConfig", "ssl-plugin"})
public final class SslConfig {
    @JvmField
    @Nullable
    public String host;
    @JvmField
    public boolean insecure = true;
    @JvmField
    public boolean secure = true;
    @JvmField
    public int securePort = 443;
    @JvmField
    public int insecurePort = 80;
    @JvmField
    public boolean redirect;
    @JvmField
    public boolean http2 = true;
    @JvmField
    public boolean sniHostCheck = true;
    @JvmField
    @NotNull
    public TlsConfig tlsConfig = TlsConfig.INTERMEDIATE;
    @NotNull
    private final PrivateConfig pvt = new PrivateConfig();
    @Nullable
    private Consumer<ServerConnector> configConnectors;
    @JvmField
    @Nullable
    public Provider securityProvider;
    @Nullable
    private TrustConfig trustConfig;

    @NotNull
    public final PrivateConfig getPvt() {
        return this.pvt;
    }

    @JvmOverloads
    public final void pemFromPath(@NotNull String certificatePath, @NotNull String privateKeyPath, @Nullable String password) {
        Object object;
        PrivateConfig privateConfig;
        block3: {
            Path keyPath;
            Path certPath;
            block2: {
                Intrinsics.checkNotNullParameter((Object)certificatePath, (String)"certificatePath");
                Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
                certPath = Paths.get(certificatePath, new String[0]);
                keyPath = Paths.get(privateKeyPath, new String[0]);
                privateConfig = this.pvt;
                object = password;
                if (object == null) break block2;
                String string = object;
                PrivateConfig privateConfig2 = privateConfig;
                boolean bl = false;
                char[] cArray = password.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                X509ExtendedKeyManager x509ExtendedKeyManager = PemUtils.loadIdentityMaterial((Path)certPath, (Path)keyPath, (char[])cArray);
                privateConfig = privateConfig2;
                object = x509ExtendedKeyManager;
                if (x509ExtendedKeyManager != null) break block3;
            }
            object = PemUtils.loadIdentityMaterial((Path)certPath, (Path)keyPath);
        }
        privateConfig.setKeyManager((X509ExtendedKeyManager)object);
    }

    public static /* synthetic */ void pemFromPath$default(SslConfig sslConfig, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        sslConfig.pemFromPath(string, string2, string3);
    }

    @JvmOverloads
    public final void pemFromClasspath(@NotNull String certificateFile, @NotNull String privateKeyFile, @Nullable String password) {
        Object object;
        PrivateConfig privateConfig;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)certificateFile, (String)"certificateFile");
                Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
                privateConfig = this.pvt;
                object = password;
                if (object == null) break block2;
                String string = object;
                PrivateConfig privateConfig2 = privateConfig;
                boolean bl = false;
                char[] cArray = password.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                X509ExtendedKeyManager x509ExtendedKeyManager = PemUtils.loadIdentityMaterial((String)certificateFile, (String)privateKeyFile, (char[])cArray);
                privateConfig = privateConfig2;
                object = x509ExtendedKeyManager;
                if (x509ExtendedKeyManager != null) break block3;
            }
            object = PemUtils.loadIdentityMaterial((String)certificateFile, (String)privateKeyFile);
        }
        privateConfig.setKeyManager((X509ExtendedKeyManager)object);
    }

    public static /* synthetic */ void pemFromClasspath$default(SslConfig sslConfig, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        sslConfig.pemFromClasspath(string, string2, string3);
    }

    @JvmOverloads
    public final void pemFromInputStream(@NotNull InputStream certificateInputStream, @NotNull InputStream privateKeyInputStream, @Nullable String password) {
        Object object;
        PrivateConfig privateConfig;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)certificateInputStream, (String)"certificateInputStream");
                Intrinsics.checkNotNullParameter((Object)privateKeyInputStream, (String)"privateKeyInputStream");
                privateConfig = this.pvt;
                object = password;
                if (object == null) break block2;
                String string = object;
                PrivateConfig privateConfig2 = privateConfig;
                boolean bl = false;
                char[] cArray = password.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                X509ExtendedKeyManager x509ExtendedKeyManager = PemUtils.loadIdentityMaterial((InputStream)certificateInputStream, (InputStream)privateKeyInputStream, (char[])cArray);
                privateConfig = privateConfig2;
                object = x509ExtendedKeyManager;
                if (x509ExtendedKeyManager != null) break block3;
            }
            object = PemUtils.loadIdentityMaterial((InputStream)certificateInputStream, (InputStream)privateKeyInputStream);
        }
        privateConfig.setKeyManager((X509ExtendedKeyManager)object);
    }

    public static /* synthetic */ void pemFromInputStream$default(SslConfig sslConfig, InputStream inputStream, InputStream inputStream2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        sslConfig.pemFromInputStream(inputStream, inputStream2, string);
    }

    @JvmOverloads
    public final void pemFromString(@NotNull String certificateString, @NotNull String privateKeyString, @Nullable String password) {
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)certificateString, (String)"certificateString");
        Intrinsics.checkNotNullParameter((Object)privateKeyString, (String)"privateKeyString");
        String string = password;
        if (string != null) {
            char[] cArray2 = string.toCharArray();
            cArray = cArray2;
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        } else {
            cArray = null;
        }
        this.pvt.setKeyManager(PemUtils.parseIdentityMaterial((String)certificateString, (String)privateKeyString, (char[])cArray));
    }

    public static /* synthetic */ void pemFromString$default(SslConfig sslConfig, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        sslConfig.pemFromString(string, string2, string3);
    }

    @JvmOverloads
    public final void keystoreFromPath(@NotNull String keyStorePath, @NotNull String keyStorePassword, @Nullable String identityPassword) {
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Path path = Paths.get(keyStorePath, new String[0]);
        char[] cArray = keyStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.pvt.setKeyStore(KeyStoreUtils.loadKeyStore((Path)path, (char[])cArray));
        String string = identityPassword;
        if (string == null) {
            string = keyStorePassword;
        }
        this.pvt.setIdentityPassword(string);
    }

    public static /* synthetic */ void keystoreFromPath$default(SslConfig sslConfig, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        sslConfig.keystoreFromPath(string, string2, string3);
    }

    @JvmOverloads
    public final void keystoreFromInputStream(@NotNull InputStream keyStoreInputStream, @NotNull String keyStorePassword, @Nullable String identityPassword) {
        Intrinsics.checkNotNullParameter((Object)keyStoreInputStream, (String)"keyStoreInputStream");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        char[] cArray = keyStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.pvt.setKeyStore(KeyStoreUtils.loadKeyStore((InputStream)keyStoreInputStream, (char[])cArray));
        String string = identityPassword;
        if (string == null) {
            string = keyStorePassword;
        }
        this.pvt.setIdentityPassword(string);
    }

    public static /* synthetic */ void keystoreFromInputStream$default(SslConfig sslConfig, InputStream inputStream, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        sslConfig.keystoreFromInputStream(inputStream, string, string2);
    }

    @JvmOverloads
    public final void keystoreFromClasspath(@NotNull String keyStoreFile, @NotNull String keyStorePassword, @Nullable String identityPassword) {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        char[] cArray = keyStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.pvt.setKeyStore(KeyStoreUtils.loadKeyStore((String)keyStoreFile, (char[])cArray));
        String string = identityPassword;
        if (string == null) {
            string = keyStorePassword;
        }
        this.pvt.setIdentityPassword(string);
    }

    public static /* synthetic */ void keystoreFromClasspath$default(SslConfig sslConfig, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        sslConfig.keystoreFromClasspath(string, string2, string3);
    }

    @Nullable
    public final Consumer<ServerConnector> getConfigConnectors() {
        return this.configConnectors;
    }

    public final void configConnectors(@Nullable Consumer<ServerConnector> configConnectors) {
        this.configConnectors = configConnectors;
    }

    @Nullable
    public final TrustConfig getTrustConfig() {
        return this.trustConfig;
    }

    public final void withTrustConfig(@NotNull Consumer<TrustConfig> trustConfigConsumer) {
        Intrinsics.checkNotNullParameter(trustConfigConsumer, (String)"trustConfigConsumer");
        TrustConfig temp = new TrustConfig();
        trustConfigConsumer.accept(temp);
        this.trustConfig = temp;
    }

    @JvmOverloads
    public final void pemFromPath(@NotNull String certificatePath, @NotNull String privateKeyPath) {
        Intrinsics.checkNotNullParameter((Object)certificatePath, (String)"certificatePath");
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        SslConfig.pemFromPath$default(this, certificatePath, privateKeyPath, null, 4, null);
    }

    @JvmOverloads
    public final void pemFromClasspath(@NotNull String certificateFile, @NotNull String privateKeyFile) {
        Intrinsics.checkNotNullParameter((Object)certificateFile, (String)"certificateFile");
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        SslConfig.pemFromClasspath$default(this, certificateFile, privateKeyFile, null, 4, null);
    }

    @JvmOverloads
    public final void pemFromInputStream(@NotNull InputStream certificateInputStream, @NotNull InputStream privateKeyInputStream) {
        Intrinsics.checkNotNullParameter((Object)certificateInputStream, (String)"certificateInputStream");
        Intrinsics.checkNotNullParameter((Object)privateKeyInputStream, (String)"privateKeyInputStream");
        SslConfig.pemFromInputStream$default(this, certificateInputStream, privateKeyInputStream, null, 4, null);
    }

    @JvmOverloads
    public final void pemFromString(@NotNull String certificateString, @NotNull String privateKeyString) {
        Intrinsics.checkNotNullParameter((Object)certificateString, (String)"certificateString");
        Intrinsics.checkNotNullParameter((Object)privateKeyString, (String)"privateKeyString");
        SslConfig.pemFromString$default(this, certificateString, privateKeyString, null, 4, null);
    }

    @JvmOverloads
    public final void keystoreFromPath(@NotNull String keyStorePath, @NotNull String keyStorePassword) {
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        SslConfig.keystoreFromPath$default(this, keyStorePath, keyStorePassword, null, 4, null);
    }

    @JvmOverloads
    public final void keystoreFromInputStream(@NotNull InputStream keyStoreInputStream, @NotNull String keyStorePassword) {
        Intrinsics.checkNotNullParameter((Object)keyStoreInputStream, (String)"keyStoreInputStream");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        SslConfig.keystoreFromInputStream$default(this, keyStoreInputStream, keyStorePassword, null, 4, null);
    }

    @JvmOverloads
    public final void keystoreFromClasspath(@NotNull String keyStoreFile, @NotNull String keyStorePassword) {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        SslConfig.keystoreFromClasspath$default(this, keyStoreFile, keyStorePassword, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/javalin/community/ssl/SslConfig$LoadedIdentity;", "", "(Ljava/lang/String;I)V", "NONE", "KEY_MANAGER", "KEY_STORE", "ssl-plugin"})
    public static final class LoadedIdentity
    extends Enum<LoadedIdentity> {
        public static final /* enum */ LoadedIdentity NONE = new LoadedIdentity();
        public static final /* enum */ LoadedIdentity KEY_MANAGER = new LoadedIdentity();
        public static final /* enum */ LoadedIdentity KEY_STORE = new LoadedIdentity();
        private static final /* synthetic */ LoadedIdentity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoadedIdentity[] values() {
            return (LoadedIdentity[])$VALUES.clone();
        }

        public static LoadedIdentity valueOf(String value) {
            return Enum.valueOf(LoadedIdentity.class, value);
        }

        @NotNull
        public static EnumEntries<LoadedIdentity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loadedIdentityArray = new LoadedIdentity[]{LoadedIdentity.NONE, LoadedIdentity.KEY_MANAGER, LoadedIdentity.KEY_STORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lio/javalin/community/ssl/SslConfig$PrivateConfig;", "", "()V", "identityPassword", "", "getIdentityPassword", "()Ljava/lang/String;", "setIdentityPassword", "(Ljava/lang/String;)V", "value", "Ljavax/net/ssl/X509ExtendedKeyManager;", "keyManager", "getKeyManager", "()Ljavax/net/ssl/X509ExtendedKeyManager;", "setKeyManager", "(Ljavax/net/ssl/X509ExtendedKeyManager;)V", "Ljava/security/KeyStore;", "keyStore", "getKeyStore", "()Ljava/security/KeyStore;", "setKeyStore", "(Ljava/security/KeyStore;)V", "<set-?>", "Lio/javalin/community/ssl/SslConfig$LoadedIdentity;", "loadedIdentity", "getLoadedIdentity", "()Lio/javalin/community/ssl/SslConfig$LoadedIdentity;", "ssl-plugin"})
    public static final class PrivateConfig {
        @Nullable
        private X509ExtendedKeyManager keyManager;
        @Nullable
        private KeyStore keyStore;
        @Nullable
        private String identityPassword;
        @NotNull
        private LoadedIdentity loadedIdentity = LoadedIdentity.NONE;

        @Nullable
        public final X509ExtendedKeyManager getKeyManager() {
            return this.keyManager;
        }

        public final void setKeyManager(@Nullable X509ExtendedKeyManager value) {
            if (this.loadedIdentity != LoadedIdentity.NONE) {
                throw new SslConfigException(SslConfigException.Types.MULTIPLE_IDENTITY_LOADING_OPTIONS);
            }
            if (value != null) {
                this.loadedIdentity = LoadedIdentity.KEY_MANAGER;
                this.keyManager = value;
            }
        }

        @Nullable
        public final KeyStore getKeyStore() {
            return this.keyStore;
        }

        public final void setKeyStore(@Nullable KeyStore value) {
            if (this.loadedIdentity != LoadedIdentity.NONE) {
                throw new SslConfigException(SslConfigException.Types.MULTIPLE_IDENTITY_LOADING_OPTIONS);
            }
            if (value != null) {
                this.loadedIdentity = LoadedIdentity.KEY_STORE;
                this.keyStore = value;
            }
        }

        @Nullable
        public final String getIdentityPassword() {
            return this.identityPassword;
        }

        public final void setIdentityPassword(@Nullable String string) {
            this.identityPassword = string;
        }

        @NotNull
        public final LoadedIdentity getLoadedIdentity() {
            return this.loadedIdentity;
        }
    }
}

